package com.twentyfouri.tvlauncher.setupwizard.utils

import android.content.Context
import com.twentyfouri.smartmodel.FlowSmartApi
import com.twentyfouri.tvlauncher.common.analytics.YouboraAnalytics
import com.twentyfouri.tvlauncher.common.data.*
import com.twentyfouri.tvlauncher.common.utils.logging.OselToggleableLogger
import com.twentyfouri.tvlauncher.common.utils.logging.OselToggleableLoggerPermissions
import com.twentyfouri.tvlauncher.setupwizard.postcoresetup.PostCoreSetupViewModelFactory

object InjectorUtils {

    //region Providers

    /**
     * DI providers
     * Responsible mainly for creating dependency tree and also for copying and passing mainly
     * 'Input Objects' - {@link Context} or other objects which are dependent on UI and must be passed
     * from outside. It is something like Component in Dagger. Should call only one usually getter
     * function with the dependent parameters that may be just 'input objects', getters (when it
     * needs just 'input objects') or providers that should again accept just 'input objects' as
     * parameters. Providers which are not used from outside should be private.
     * This defines WHAT are dependencies (other nodes) of one node.
     */
    fun providePostCoreSetupViewModelFactory(context: Context) = getPostCoreSetupViewModelFactory(
        context,
        provideSmartApi(context),
        getResourceRepository(context),
        getAnalytics(context)
    )

    private fun provideSmartApi(context: Context) = getSmartApi(
        context,
        getCredentialsRepository(context)
    )

    //endregion



    //region Getters

    /**
     * DI getters
     * Sum up the existing DI nodes, like Module in Dagger. Each function represent constructor of
     * one node in the dependency tree. Should call only one singleton or constructor directly as
     * an implementation. Implementation must be on one row! Cannot call other DI getters!
     * This is like HOW one node processes an input to an output.
     */

    private fun getCredentialsRepository(c: Context) = SetupDataRepository.getInstance(c)

    private fun getResourceRepository(c: Context) = ResourceRepository(c)

    private fun getAnalytics(c: Context) = YouboraAnalytics(c)

    private fun getPostCoreSetupViewModelFactory(c: Context, smartApi: FlowSmartApi, resourceRepo: ResourceRepository, analytics: YouboraAnalytics) = PostCoreSetupViewModelFactory(c, smartApi, resourceRepo, analytics)

    private fun getSmartApi(c: Context, setupDataRepo: SetupDataRepository) =
        SmartApiRepository.getSmartApi(c, setupDataRepo,
            OselToggleableLogger(OselToggleableLoggerPermissions(c))
        )

    //endregion
}