package com.twentyfouri.tvlauncher.setupwizard.postcoresetup

import android.annotation.SuppressLint
import android.content.Context
import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import com.twentyfouri.smartmodel.FlowSmartApi
import com.twentyfouri.tvlauncher.common.analytics.YouboraAnalytics
import com.twentyfouri.tvlauncher.common.data.ResourceRepository

@Suppress("UNCHECKED_CAST")
class PostCoreSetupViewModelFactory(
    var context: Context,
    private val api: FlowSmartApi?,
    private val resourceRepository: ResourceRepository,
    private val analytics: YouboraAnalytics
): ViewModelProvider.Factory {

    @SuppressLint("WorldReadableFiles")
    override fun <T : ViewModel> create(modelClass: Class<T>): T {
        if (modelClass == PostCoreSetupViewModel::class.java) {
            var model: PostCoreSetupModel? = null
            try {
                model = PostCoreSetupModel(context.contentResolver!!, context)
            } catch (e: Exception) {
            }
            return PostCoreSetupViewModel(model!!, api, resourceRepository, context, analytics) as T
        }
        throw IllegalArgumentException("")
    }
}