package com.twentyfouri.tvlauncher.setupwizard.postcoresetup

import android.app.Activity
import android.content.Context
import android.content.IntentFilter
import android.os.Bundle
import android.view.View
import android.view.WindowManager
import android.view.inputmethod.InputMethodManager
import androidx.fragment.app.FragmentActivity
import com.twentyfouri.tvlauncher.common.receiver.SerialNumberReceiver
import com.twentyfouri.tvlauncher.common.ui.ForceLocaleHelper
import com.twentyfouri.tvlauncher.common.ui.messagedialog.*
import com.twentyfouri.tvlauncher.common.utils.DeviceId
import com.twentyfouri.tvlauncher.common.utils.SerialNumberReceiverHelper
import com.twentyfouri.tvlauncher.setupwizard.R
import io.github.inflationx.calligraphy3.CalligraphyConfig
import io.github.inflationx.calligraphy3.CalligraphyInterceptor
import io.github.inflationx.viewpump.ViewPump
import io.github.inflationx.viewpump.ViewPumpContextWrapper

class PostCoreSetupActivity : FragmentActivity(), OnFragmentInteractionListener, MessageDialogFragmentListener, SerialNumberReceiverHelper {

    private var onButtonClick: (() -> Unit)? = null

    companion object {
        const val TAG_WRONG_CREDENTIALS_DIALOG_FRAGMENT = "tag_wrong_credentials_dialog_fragment"
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        //getting S/N from custom SDMC broadcast
        if (com.twentyfouri.tvlauncher.common.Flavor().getSerialNumberFromBroadcast()) {
            if(DeviceId.isSerialNumberStored(this)) {
                continueWithCreation()
            } else {
                val serialNumberIntentFilter = IntentFilter()
                serialNumberIntentFilter.addAction(SerialNumberReceiver.INTENT_FILTER_ACTION)
                registerReceiver(SerialNumberReceiver(this), serialNumberIntentFilter)
            }
        } else {
            continueWithCreation()
        }
    }

    private fun continueWithCreation() {
        initCalligraphy()
        window.setSoftInputMode(
            WindowManager.
                LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN)
        setContentView(R.layout.activity_post_core_setup)
    }

    private fun initCalligraphy() {
        ViewPump.init(
            ViewPump.builder()
                .addInterceptor(
                    CalligraphyInterceptor(
                        CalligraphyConfig.Builder()
                            .setDefaultFontPath(resources.getString(R.string.font_path_semibold))
                            .setFontAttrId(R.attr.fontPath)
                            .build()
                    )
                )
                .build()
        )
    }

    //this is necessary for custom fonts
    override fun attachBaseContext(newBase: Context) {
        super.attachBaseContext(
            ForceLocaleHelper.onAttachBaseContext(
                ViewPumpContextWrapper.wrap(newBase)
            )
        )
    }

    override fun onBackPressed() {
        if (!(supportFragmentManager.findFragmentById(R.id.post_core_setup_fragment) as PostCoreSetupFragment).goBack())
            super.onBackPressed()
    }

    // region PostCoreSetupFragment

    override fun onShouldHideKeyboard() {
        val inm = getSystemService(Activity.INPUT_METHOD_SERVICE) as InputMethodManager
        var view: View? = null
        if (currentFocus == null) {
            view = View(this)
        }
        inm.hideSoftInputFromWindow(currentFocus?.windowToken ?: view?.windowToken, 0)
    }

    override fun onFinish() {
        setResult(Activity.RESULT_OK)
        finish()
    }

    override fun onWrongCredentialsError(
        title: String?,
        message: String,
        buttonText: String?,
        onButtonClick: (() -> Unit)?
    ) {
        val messageDialogModel = MessageDialogModel(
                title ?: (resources.getString(R.string.dialog_message_wrong_credentials)),
                message,
                buttonText ?: "",
                MessageDialogCodes.loginFailure
        )
        this.onButtonClick = onButtonClick
        val dialogFragment = MessageDialogFragment.newInstance(messageDialogModel)
        dialogFragment.show(supportFragmentManager, TAG_WRONG_CREDENTIALS_DIALOG_FRAGMENT)
    }
    // endregion PostCoreSetupFragment

    // region MessageDialogFragment

    override fun onResult(answer: MessageDialogAction): Boolean {
        if (onButtonClick != null) {
            onButtonClick?.invoke()
        } else {
            (supportFragmentManager.findFragmentById(R.id.post_core_setup_fragment) as PostCoreSetupFragment).onDismiss()
        }
        return true
    }

    // endregion MessageDialogFragment

    override fun onSerialNumberReceived(context: Context?) {
        continueWithCreation()
    }
}
