package com.twentyfouri.tvlauncher.setupwizard.postcoresetup

import android.content.Context
import android.os.Bundle
import android.view.View
import android.widget.Button
import androidx.lifecycle.ViewModelProvider
import com.twentyfouri.tvlauncher.common.extensions.enlarge
import com.twentyfouri.tvlauncher.setupwizard.BuildConfig
import com.twentyfouri.tvlauncher.setupwizard.R
import com.twentyfouri.tvlauncher.setupwizard.basesetup.BaseSetupView
import com.twentyfouri.tvlauncher.setupwizard.databinding.FragmentPostCoreSetupBinding
import com.twentyfouri.tvlauncher.setupwizard.utils.InjectorUtils

abstract class AbstractPostCoreSetupFragment : BaseFragment<FragmentPostCoreSetupBinding>(), BaseSetupView {

    override val layoutRes = R.layout.fragment_post_core_setup
    private var listener: OnFragmentInteractionListener? = null
    private lateinit var viewModel: PostCoreSetupViewModel

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        arguments?.let {
        }
    }

    override fun onBindViewModel(binding: FragmentPostCoreSetupBinding) {
        val applicationContext = activity?.applicationContext
        val factory = InjectorUtils.providePostCoreSetupViewModelFactory(applicationContext!!)
        viewModel = ViewModelProvider(this, factory)[PostCoreSetupViewModel::class.java]
        viewModel.view = this
        viewModel.defaultText = resources.getString(R.string.input_you)
        binding.viewModel = viewModel
        binding.postCoreSetupVersion.text = resources.getString(R.string.version, BuildConfig.VERSION_NAME)
        binding.viewModel?.onCleanStart(activity?.parent)
    }

    override fun onDestroyView() {
        super.onDestroyView()
        viewModel.view = null
    }

    override fun onAttach(context: Context) {
        super.onAttach(context)
        if (context is OnFragmentInteractionListener) {
            listener = context
        } else {
            throw RuntimeException("$context must implement OnFragmentInteractionListener")
        }
    }

    override fun onDetach() {
        super.onDetach()
        listener = null
    }

    fun goBack(): Boolean {
        return viewModel.switchToPreviousScreen()
    }

    override fun onFocusChange(v: View?, hasFocus: Boolean) {
        if (v is Button) {
            v.enlarge(hasFocus)
        }
    }

    override fun onScreenSwitched(screen: Screens) {
        mBinding.executePendingBindings()
        if (mBinding.postCoreSetupButtonOk.visibility == View.VISIBLE){
            listener?.onShouldHideKeyboard()
            mBinding.postCoreSetupButtonOk.requestFocus()
        }
        if (mBinding.postCoreSetupEdit.visibility == View.VISIBLE){
            listener?.onShouldHideKeyboard()
            mBinding.postCoreSetupEdit.requestFocus()
        }
    }

    override fun showMessageDialog(
        title: String?,
        message: String,
        buttonText: String?,
        onButtonClick: (() -> Unit)?
    ) {
        listener?.onWrongCredentialsError(title, message, buttonText, onButtonClick)
    }

    fun onDismiss() {
        if (mBinding.postCoreSetupTitle.text != resources.getString(R.string.title_enter_pin)) { //Stay in pin screen when invalid credentials are entered.
            goBack()
        }
    }

    override fun onFinish() {
        listener?.onFinish()
    }
}
