package com.twentyfouri.tvlauncher.setupwizard

import android.content.Context
import com.twentyfouri.smartmodel.FlowSmartApi
import com.twentyfouri.smartmodel.serialization.SmartDataObject
import com.twentyfouri.smartmodel.model.user.SmartLoginCredentials
import com.twentyfouri.smartmodel.model.user.SmartUserProfileReference

import com.twentyfouri.tvlauncher.setupwizard.basesetup.BaseSetupModel
import com.twentyfouri.tvlauncher.setupwizard.postcoresetup.Screens
import com.twentyfouri.tvlauncher.setupwizard.postcoresetup.models.*

abstract class FlavorBase {

    open fun getInitialSetupData(smartApi: FlowSmartApi, context: Context): String? = null
    abstract fun getUserProfileReference(userName: String): SmartUserProfileReference
    @Suppress("SpellCheckingInspection")
    abstract fun gdprProfileChangeObject(isGdrpAccepted: Boolean?): SmartDataObject
    @Suppress("SpellCheckingInspection")
    abstract fun isGdprAcceptedProfile(extras: SmartDataObject, modelRecommendations: Boolean): Boolean?
    abstract fun getLoginCredentialsType(loginCredentials: LoginCredentials): SmartLoginCredentials
    abstract fun getImeAction(currentScreen: Screens, screens: List<Screens>): Int
    abstract val usernameScreenList: List<Screens>
    abstract val pinScreenList: List<Screens>
    open fun resetSessionPersistence(context: Context) = Unit
    open fun processLogin(credentials: SmartLoginCredentials) = Unit

    fun getScreenModel(screen: Screens): BaseSetupModel = when (screen) {
        Screens.InitialScreen -> InitialScreenModel()
        Screens.UsernameScreen -> UsernameScreenModel()
        Screens.PinScreen -> PinScreenModel()
        Screens.PasswordScreen -> PasswordScreenModel()
        Screens.RecommendationsScreen -> RecommendationsScreenModel()
        Screens.CaptchaScreen -> CaptchaScreenModel()
    }
}

class LoginCredentials(
    var pin: String?,
    var username: String?,
    var password: String?
)