package com.twentyfouri.tvlauncher.common.widgets

import android.content.Context
import android.graphics.Canvas
import android.graphics.Color
import android.graphics.Paint
import android.text.Spannable
import android.text.TextPaint
import android.text.style.CharacterStyle
import android.text.style.UpdateAppearance
import android.util.AttributeSet
import android.widget.TextView

class OutlineTextView: TextView {

    constructor(context: Context?) : super(context)
    constructor(context: Context?, attrs: AttributeSet?) : super(context, attrs)
    constructor(context: Context?, attrs: AttributeSet?, defStyleAttr: Int) : super(context, attrs, defStyleAttr)
    constructor(context: Context?, attrs: AttributeSet?, defStyleAttr: Int, defStyleRes: Int) : super(context, attrs, defStyleAttr, defStyleRes)

    override fun onDraw(canvas: Canvas?) {
        val textPaint = paint
        val previousStyle = textPaint.style
        val previousJoin = textPaint.strokeJoin
        val previousWidth = textPaint.strokeWidth
        val previousTextColor = this.currentTextColor

        setTextColor(Color.BLACK)
        textPaint.style = Paint.Style.FILL_AND_STROKE
        textPaint.strokeJoin = Paint.Join.ROUND
        textPaint.strokeWidth = 3f

        // Draw outline and background only.
        super.onDraw(canvas)

        // Restore original settings.
        setTextColor(previousTextColor)
        textPaint.style = previousStyle
        textPaint.strokeJoin = previousJoin
        textPaint.strokeWidth = previousWidth

        // Remove the background.
        setBackgroundSpans(Color.TRANSPARENT)
        // Draw foreground only.
        super.onDraw(canvas)
        // Restore the background.
        setBackgroundSpans(Color.BLACK)
    }

    private fun setBackgroundSpans(color: Int) {
        val itext = text
        if(itext is Spannable) {
            for(span in itext.getSpans(0, itext.length, MutableBackgroundColorSpan::class.java)) {
                span.setBackgroundColorSPan(color)
            }
        }
    }


    private inner class MutableBackgroundColorSpan(private var color: Int): CharacterStyle(), UpdateAppearance {

        fun setBackgroundColorSPan(color: Int) {
            this.color = color
        }

        fun getBackgroundColor(): Int {
            return color
        }

        override fun updateDrawState(tp: TextPaint?) {
            tp?.bgColor = color
        }
    }
}