package com.twentyfouri.tvlauncher.common.utils

import android.content.Context
import com.twentyfouri.tvlauncher.common.provider.TimeProvider

object GlobalPinTimer {

    private fun getSharedPreferences(context: Context) =
        context.getSharedPreferences(SHARED_PREFERENCES_GLOBAL_PIN_TIMER, Context.MODE_PRIVATE)

    fun saveTime(context: Context) {
        getSharedPreferences(context).edit().putLong(PIN_INSERTED_TIME, TimeProvider.nowMs()).apply()
    }

    fun isRunning(context: Context, time: Long): Boolean {
        return if (getSharedPreferences(context).getLong(PIN_INSERTED_TIME, 0L) == 0L) {
            false
        } else {
            (time - getSharedPreferences(context).getLong(PIN_INSERTED_TIME, 0L) < 30/*minutes*/ * 60/*seconds*/ * 1000/*millis*/)
        }
    }

    private const val SHARED_PREFERENCES_GLOBAL_PIN_TIMER = "global_pin_timer"
    private const val PIN_INSERTED_TIME = "pin_inserted_time"
}
