package com.twentyfouri.tvlauncher.common.ui.pindialog

import android.content.Context
import android.os.Bundle
import androidx.lifecycle.ViewModelProvider
import com.twentyfouri.tvlauncher.common.R
import com.twentyfouri.tvlauncher.common.databinding.DialogPinBinding
import com.twentyfouri.tvlauncher.common.ui.BaseDialogFragment
import com.twentyfouri.tvlauncher.common.utils.logging.OselToggleableLogger
import timber.log.Timber

class PinDialogFragment: BaseDialogFragment<DialogPinBinding>(), PinDialogView {
    override val layoutRes = R.layout.dialog_pin
    var mListener: PinDialogFragmentListener? = null
    private lateinit var viewModel: PinDialogViewModel

    override fun onBindViewModel(binding: DialogPinBinding) {
        viewModel = ViewModelProvider(this)[PinDialogViewModel::class.java]
        viewModel.view = this
        viewModel.model = arguments?.getParcelable(PARAM_MODEL)
        binding.viewModel = viewModel
    }

    companion object {
        private const val PARAM_MODEL = "model"

        fun newInstance(model: PinDialogModel) = PinDialogFragment().apply {
            arguments = Bundle().apply {
                putParcelable(PARAM_MODEL, model)
            }
        }
    }

    // region Binded

    override fun onResult(answer: Boolean?, keyCode: Int?) {
        Timber.tag(OselToggleableLogger.TAG_UI_LOG).d("Dialog PIN entered: $answer")
        mListener?.onResult(answer, keyCode)
        this.dismiss()
    }

    // endregion

    override fun onStart() {
        super.onStart()

        val width = resources.getDimensionPixelSize(R.dimen.pin_dialog_width)
        val height = resources.getDimensionPixelSize(R.dimen.pin_dialog_height)

        dialog?.window?.setLayout(width, height)

    }

    override fun onAttach(context: Context) {
        super.onAttach(context)
        //WARNING this can override the listener if it was set from outside previously
        if (context is PinDialogFragmentListener)
            mListener = context
    }

    override fun onResume() {
        super.onResume()
        Timber.tag(OselToggleableLogger.TAG_UI_LOG).d("Dialog PIN resumed")
    }

    override fun onPause() {
        Timber.tag(OselToggleableLogger.TAG_UI_LOG).d("Dialog PIN paused")
        super.onPause()
    }
}
