package com.twentyfouri.tvlauncher.common.ui.messagedialog

import android.view.View
import android.widget.Button
import android.widget.CheckBox
import android.widget.TextView
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import com.twentyfouri.tvlauncher.common.ui.SemaphoreState
import com.twentyfouri.tvlauncher.common.utils.logging.OselToggleableLogger
import timber.log.Timber

class MessageDialogViewModel: ViewModel() {

    var model: MessageDialogModel? = null
        set(value) {
            field = value
            initView()
        }

    var view: MessageDialogView? = null

    private fun initView() {
        model?.let {
            messageVisiblity.value = if(it.message.isEmpty()) View.GONE else View.VISIBLE
            message.value = it.message

            descriptionVisiblity.value = if(it.description.isNullOrEmpty()) View.GONE else View.VISIBLE
            description.value = it.description

            optionAButtonText.value = it.optionsButtonText?.getOrNull(0)
            optionAVisiblity.value = if(it.optionsButtonText?.getOrNull(0).isNullOrEmpty()) View.GONE else View.VISIBLE

            optionBButtonText.value = it.optionsButtonText?.getOrNull(1)
            optionBVisiblity.value = if(it.optionsButtonText?.getOrNull(1).isNullOrEmpty()) View.GONE else View.VISIBLE

            optionCButtonText.value = it.optionsButtonText?.getOrNull(2)
            optionCVisiblity.value = if(it.optionsButtonText?.getOrNull(2).isNullOrEmpty()) View.GONE else View.VISIBLE

            cancelVisiblity.value = if(it.cancelButtonText.isNullOrEmpty()) View.GONE else View.VISIBLE
            cancelButtonText.value = it.cancelButtonText

            code.value = it.code

            checkboxVisibility.value = if(it.checkboxText.isNullOrEmpty()) View.GONE else View.VISIBLE
            checkbox.value = it.checkboxText

            semaphoreState.value = it.semaphoreState
        }
    }

    // region Binded

    val message = MutableLiveData<String>()
    val description = MutableLiveData<String>()
    val optionAButtonText = MutableLiveData<String>()
    val optionBButtonText = MutableLiveData<String>()
    val optionCButtonText = MutableLiveData<String>()
    val cancelButtonText = MutableLiveData<String>()
    val code = MutableLiveData<String>()
    val checkbox = MutableLiveData<String>()
    val semaphoreState = MutableLiveData<SemaphoreState>()

    val messageVisiblity = MutableLiveData<Int>()
    val descriptionVisiblity = MutableLiveData<Int>()
    val cancelVisiblity = MutableLiveData<Int>()
    val checkboxVisibility = MutableLiveData<Int>()
    val optionAVisiblity = MutableLiveData<Int>()
    val optionBVisiblity = MutableLiveData<Int>()
    val optionCVisiblity = MutableLiveData<Int>()


    @Suppress("UNUSED_PARAMETER")
    fun onOptionAButtonClicked(v: View) {
        Timber.tag(OselToggleableLogger.TAG_UI_LOG).d("Dialog ${code.value} button selected: ${optionAButtonText.value}")
        view?.onResult(MessageDialogAction.Result(OPTION_A))
    }

    @Suppress("UNUSED_PARAMETER")
    fun onOptionBButtonClicked(v: View) {
        Timber.tag(OselToggleableLogger.TAG_UI_LOG).d("Dialog ${code.value} button selected: ${optionBButtonText.value}")
        view?.onResult(MessageDialogAction.Result(OPTION_B))
    }

    @Suppress("UNUSED_PARAMETER")
    fun onOptionCButtonClicked(v: View) {
        Timber.tag(OselToggleableLogger.TAG_UI_LOG).d("Dialog ${code.value} button selected: ${optionCButtonText.value}")
        view?.onResult(MessageDialogAction.Result(OPTION_C))
    }

    @Suppress("UNUSED_PARAMETER")
    fun onCancelButtonClicked(v: View) {
        Timber.tag(OselToggleableLogger.TAG_UI_LOG).d("Dialog ${code.value} button selected: ${cancelButtonText.value}")
        view?.onResult(MessageDialogAction.Result(CANCEL))
    }

    @Suppress("UNUSED_PARAMETER")
    fun onCheckBoxClicked(v: View) {
        view?.onResult(MessageDialogAction.CheckBox((v as CheckBox).isChecked))
    }

    fun onFocusChange(v: View, hasFocus: Boolean) {
        when (v) {
            is Button -> {
                if(hasFocus) Timber.tag(OselToggleableLogger.TAG_UI_LOG).d("Dialog ${code.value} button focused: ${v.text}")
                view?.onFocusChange(v, hasFocus)
            }
            is TextView -> {
                if(hasFocus) Timber.tag(OselToggleableLogger.TAG_UI_LOG).d("Dialog ${code.value} code focused: ${v.text}")
            }
        }
    }

    // endregion
}