package com.twentyfouri.tvlauncher.common.ui.messagedialog

import android.os.Parcel
import android.os.Parcelable
import com.twentyfouri.tvlauncher.common.ui.SemaphoreState

data class MessageDialogModel(
    var message: String,
    var description: String? = null,
    var optionsButtonText: Array<String?>? = null,
    var cancelButtonText: String? = null,
    var code: String,
    var checkboxText: String? = null
) : Parcelable {

    constructor(message: String, description: String?, singleButton: String, code: String) : this(
            message = message,
            description = description,
            optionsButtonText = arrayOf(singleButton),
            cancelButtonText = null,
            code = code,
            checkboxText = null
    )

    constructor(message: String, description: String?, singleButton: String, code: String, checkboxText: String?) : this(
            message = message,
            description = description,
            optionsButtonText = arrayOf(singleButton),
            cancelButtonText = null,
            code = code,
            checkboxText = checkboxText
    )

    constructor(parcel: Parcel) : this(
            message = parcel.readString() ?: "",
            description = parcel.readString(),
            optionsButtonText = parcel.createStringArray(),
            cancelButtonText = parcel.readString(),
            code = parcel.readString() ?: "",
            checkboxText = parcel.readString() ?: ""
    ) {
        val state = parcel.readString()
        if(state != null) semaphoreState = SemaphoreState.valueOf(state)
    }

    var semaphoreState: SemaphoreState? = null

    override fun writeToParcel(parcel: Parcel, flags: Int) {
        parcel.writeString(message)
        parcel.writeString(description)
        parcel.writeStringArray(optionsButtonText)
        parcel.writeString(cancelButtonText)
        parcel.writeString(code)
        parcel.writeString(semaphoreState?.name)
    }

    override fun describeContents(): Int {
        return 0
    }

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false
        other as MessageDialogModel
        if (message != other.message) return false
        if (description != other.description) return false
        if (optionsButtonText == null) {
            if (other.optionsButtonText != null) return false
        } else {
            if (other.optionsButtonText == null) return false
            if (optionsButtonText!!.contentEquals(other.optionsButtonText!!).not()) return false
        }
        if (cancelButtonText != other.cancelButtonText) return false
        if (code != other.code) return false
        if (semaphoreState?.name != other.semaphoreState?.name) return false
        return true
    }

    override fun hashCode(): Int {
        var result = message.hashCode()
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (optionsButtonText?.contentHashCode() ?: 0)
        result = 31 * result + (cancelButtonText?.hashCode() ?: 0)
        result = 31 * result + (code.hashCode())
        result = 31 * result + (semaphoreState?.name?.hashCode() ?: 0)
        return result
    }

    companion object CREATOR : Parcelable.Creator<MessageDialogModel> {
        override fun createFromParcel(parcel: Parcel): MessageDialogModel {
            return MessageDialogModel(parcel)
        }

        override fun newArray(size: Int): Array<MessageDialogModel?> {
            return arrayOfNulls(size)
        }
    }
}
