package com.twentyfouri.tvlauncher.common.ui

import android.content.Context
import com.twentyfouri.tvlauncher.common.BuildConfig
import java.util.*

object ForceLocaleHelper {
    private const val enabled =
        BuildConfig.BUILD_TYPE != "debug" || BuildConfig.FORCE_LOCALE_ON_DEBUG

    private val forceLocale = if (enabled && BuildConfig.FORCE_LOCALE.isNotEmpty()) {
        Locale(BuildConfig.FORCE_LOCALE)
    } else {
        null
    }

    fun onAttachBaseContextApplication(base: Context): Context {
        if (forceLocale == null) return base
        Locale.setDefault(forceLocale)
        return onAttachBaseContext(base)
    }

    fun onAttachBaseContext(base: Context): Context {
        if (forceLocale == null) return base
        val config = base.resources.configuration
        config.setLocale(forceLocale)
        config.setLayoutDirection(forceLocale)

        return base.createConfigurationContext(config)
    }
}