package com.twentyfouri.tvlauncher.common.ui

import android.os.Bundle
import android.view.KeyEvent
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import androidx.annotation.LayoutRes
import androidx.databinding.DataBindingUtil
import androidx.databinding.ViewDataBinding
import androidx.fragment.app.DialogFragment
import com.twentyfouri.tvlauncher.common.R

abstract class BaseDialogFragment<B : ViewDataBinding> : DialogFragment() {
    protected lateinit var mBinding: B

    @get:LayoutRes
    abstract val layoutRes: Int

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        mBinding = DataBindingUtil.inflate(inflater, layoutRes, container, false)
        mBinding.lifecycleOwner = viewLifecycleOwner
        onBindViewModel(mBinding)
        return mBinding.root
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        view.findViewById<Button>(R.id.option_a_button)?.setOnKeyListener { _, _, event ->
            // we need to dismiss dialog when GUIDE button is pressed
            if (event?.keyCode == KeyEvent.KEYCODE_GUIDE) {
                dismiss()
            }
            // false, because handling of event should continue
            false

        }
        super.onViewCreated(view, savedInstanceState)
    }

    abstract fun onBindViewModel(binding: B)
}
