package com.twentyfouri.tvlauncher.common.extensions

import android.view.View


fun View.enlarge(turnOn: Boolean) {
    if (turnOn) {
        translationZ = 1f
        scaleX = 1.2f
        scaleY = 1.2f
    } else {
        translationZ = 0f
        scaleX = 1.0f
        scaleY = 1.0f
    }
}

fun View.enlargeFromCenter(turnOn: Boolean) {
    pivotY = height.toFloat()/2
    pivotX = width.toFloat()/2
    enlarge(turnOn)
}

fun View.enlargeFromLeft(turnOn: Boolean) {
    pivotY = height.toFloat()/2
    pivotX = 0f
    enlarge(turnOn)
}
