package com.twentyfouri.tvlauncher.common.extensions

import androidx.lifecycle.MutableLiveData

fun <T> MutableLiveData<MutableCollection<T>>.add(item: T) {
    val col = value ?: mutableListOf()
    col.add(item)
    value = col
}

fun <T> MutableLiveData<MutableCollection<T>>.postAdd(item: T) {
    val col = value ?: mutableListOf()
    col.add(item)
    postValue(col)
}

@Suppress("UNCHECKED_CAST")
fun <T: List<Any>> MutableLiveData<T>.postAddAll(sectionContentNextPage: T) {
    val col = value ?: listOf()
    postValue(col.plus(sectionContentNextPage) as T)
}