package com.twentyfouri.tvlauncher.common.data.apihandler

import android.annotation.SuppressLint
import android.content.Context
import android.content.Intent
import android.os.PowerManager
import com.twentyfouri.smartmodel.model.menu.SmartNavigationTarget
import com.twentyfouri.tvlauncher.common.Flavor
import com.twentyfouri.tvlauncher.common.R
import com.twentyfouri.tvlauncher.common.extensions.ifFalse
import com.twentyfouri.tvlauncher.common.extensions.ifTrue
import com.twentyfouri.tvlauncher.common.ui.MainActivityAction
import com.twentyfouri.tvlauncher.common.ui.messagedialog.MessageDialogFragment
import com.twentyfouri.tvlauncher.common.utils.SharedPreferencesUtils

internal fun ApiHandler.restartToOffline() {
    mainActivityAction?.also {
        //this condition is there to prevent restart if we are already in offline mode
        it.isInOnlineMode().ifTrue {
            SharedPreferencesUtils.putForceOffline(true)
            it.restartActivity()
        }
    }
}

internal fun ApiHandler.restart() {
    mainActivityAction?.restartActivity()
}

internal fun ApiHandler.restartToOnline() {
    mainActivityAction?.also {
        //this condition is there to prevent restart if we are already in online mode
        it.isInOnlineMode().ifFalse {
            it.restartActivity()
        }
    }
}

internal fun ApiHandler.openLogin() {
    Flavor().clearSessionData(appContext)
    // Start setup
    if (navigatorCommon.hasContract())
        navigatorCommon.navigate(SmartNavigationTarget.toLogin())
    else
        (mainActivityAction as? Context)?.startActivity(Intent(appContext.getString(R.string.credentials_activity_name)))
}

@SuppressLint("MissingPermission") //permission is accessible only for Launcher Flavor
internal fun ApiHandler.reboot() {
    (appContext.getSystemService(Context.POWER_SERVICE) as? PowerManager)?.reboot(null)
}

internal fun ApiHandler.retry() {
    joinPreviousOrLaunchNew (block = retryBlock, synchronizedJobName = "Retry block")
}

internal fun MessageDialogFragment.backFromSubscriptionDialog() {
    (activity as? MainActivityAction)?.backFromSubscriptionDialog()
}