package com.twentyfouri.tvlauncher.common.data

import android.database.Cursor
import androidx.room.*

@Dao
interface SetupDataDao {

    @Query("SELECT * FROM ${SetupData.TABLE_NAME}")
    fun getAll(): List<SetupData>

    /**
     * Used by provider
     */

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    fun insert(setupData: SetupData): Long

    @Query("SELECT * FROM ${SetupData.TABLE_NAME}")
    fun selectAll(): Cursor

    @Query("SELECT * FROM ${SetupData.TABLE_NAME} WHERE ${SetupData.COLUMN_ID} = :id")
    fun selectById(id: Long): Cursor

    @Query("DELETE FROM ${SetupData.TABLE_NAME} WHERE ${SetupData.COLUMN_ID} = :id")
    fun deleteById(id: Long): Int

    @Update
    fun update(setupData: SetupData): Int
}