package com.twentyfouri.tvlauncher.common.data

import android.content.ContentValues
import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.PrimaryKey

@Entity(tableName = SetupData.TABLE_NAME)
data class SetupData (

    @ColumnInfo(name = SetupData.COLUMN_RECOMMENDATIONS)
    var recommendations: Boolean,

    @ColumnInfo(name = SetupData.COLUMN_SESSION_DATA)
    var sessionData: String?,

    @PrimaryKey
    @ColumnInfo(name = SetupData.COLUMN_ID)
    var id: Int = 0

) {
    companion object {
        const val TABLE_NAME = "credentials"
        const val COLUMN_ID = "id"
        const val COLUMN_RECOMMENDATIONS = "recommendations"
        const val COLUMN_SESSION_DATA = "sessionData"

        fun fromContentValues(values: ContentValues): SetupData {
            var id: Int = 0
            var recommendations: Boolean = true
            var sessionData: String? = null

            if (values.containsKey(COLUMN_ID)) {
                id = values.getAsInteger(COLUMN_ID).toInt()
            }

            if (values.containsKey(COLUMN_RECOMMENDATIONS)) {
                recommendations = values.getAsBoolean(COLUMN_RECOMMENDATIONS)
            }

            if (values.containsKey(COLUMN_SESSION_DATA)) {
                sessionData = values.getAsString(COLUMN_SESSION_DATA)
            }
            return SetupData(recommendations, sessionData, id)
        }
    }

    fun getSetupData(): String? = sessionData
}