package com.twentyfouri.tvlauncher.common

import android.content.Context
import com.twentyfouri.smartmodel.FlowSmartApi
import com.twentyfouri.smartmodel.model.error.GeneralApiException
import com.twentyfouri.smartmodel.model.error.SuspendedException
import com.twentyfouri.smartmodel.model.user.SmartSavedSession
import com.twentyfouri.smartmodel.model.user.SmartUserProfile
import com.twentyfouri.smartmodel.model.user.SmartUserProfileReference
import com.twentyfouri.smartmodel.serialization.SmartDataObject
import com.twentyfouri.tvlauncher.common.data.SetupDataRepository
import com.twentyfouri.tvlauncher.common.utils.DeviceInfoConfig
import com.twentyfouri.tvlauncher.common.utils.logging.OselToggleableLogger
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.async
import kotlinx.coroutines.withContext

abstract class FlavorBase {
    abstract fun getSmartApi(applicationContext: Context?, setupDataRepo: SetupDataRepository, oselLogger: OselToggleableLogger? = null): FlowSmartApi
    abstract suspend fun performPing(flowSmartApi: FlowSmartApi)
    abstract fun getSavedSession(setupDataString: String?): SmartSavedSession?
    abstract fun getUserProfileReference(userName: String): SmartUserProfileReference
    @Suppress("SpellCheckingInspection")
    abstract fun gdprProfileChangeObject(isGdrpAccepted: Boolean?): SmartDataObject
    open fun parentalControlProfileChangeObject(isParentalControlActivated: Boolean?) = SmartDataObject()
    @Suppress("SpellCheckingInspection")
    abstract fun isGdprAcceptedProfile(extras: SmartDataObject): Boolean?
    open fun isParentalControlActivatedProfile(extras: SmartDataObject) = false
    abstract fun getUsername(sessionData: String?): String?
    open fun getUserType(sessionData: String?): String? = null
    abstract fun getErrorMessage(e:GeneralApiException, applicationContext: Context): String
    open fun getSerialNumberFromBroadcast() = false
    open fun pinDialogWithSoftInput(): Boolean = false
    open fun showDialogs() = false
    abstract suspend fun verifyPurchasePin(flowSmartApi: FlowSmartApi, purchasePin: String)
    abstract fun clearSessionData(context: Context)
    abstract suspend fun clearEpgData(context: Context?, flowSmartApi: FlowSmartApi?)
    open fun getBaseSubscriptions(): List<String> = emptyList()
    open fun allowSubscriptionPurchaseScreen(): Boolean = false

    open val parentalRulesRefreshActivated = false
    open suspend fun updateUserParentalRule(flowSmartApi: FlowSmartApi): List<String>? = null
    open val epgExpirationDays = EPG_EXPIRATION_DAYS
    open val backendConnectionTestUrl = ""
    open val youboraAccountCode: String = "" // code links youbora account, empty by default does not initiate youbora plugin
    open val isYouboraEnabled = false
    open val seriesRecordingsEnabled = false
    open val networkCapabilityMobile: String? = null
    open val networkCapabilityWifi: String? = null
    open val networkCapabilityEth: String? = null
    open val useSafeListOfApprovedNetworks = false
    open suspend fun preStartActions(
        smartApi: FlowSmartApi,
        callback: () -> Unit,
        analyticsReport: (Exception) -> Unit,
    ) {
        withContext(Dispatchers.Main) { callback() }
    }
    open fun overrideEditionMapping(smartApi: FlowSmartApi) {}
    open fun getUserProfileId(userProfile: SmartUserProfile?): String? = null
    open fun dialogAllowedForException(exception: Exception): Boolean = true
    open fun allowCancelableDialog(e: SuspendedException): Boolean = true
    open fun handleProjectSpecificException(exception: Exception): Boolean = false //return false if exception is not handled

    open val deviceInfoConfig = DeviceInfoConfig("", "")
    open val epgDatabaseMaximumSizeMB: Int = 0
    open val firmwareVersion = GlobalScope.async { "" }

    open fun messageLicenceMobile(context: Context): String = context.getString(R.string.content_not_licensed_mobile)
    open fun messageLicenceWiFi(context: Context): String = context.getString(R.string.content_not_licensed_wifi)
    open fun messageLicenceEth(context: Context): String = context.getString(R.string.content_not_licensed_eth)

    open suspend fun getSessionInfo(context: Context): String = "no info"

    open val shouldIgnoreNotFoundException = false
    open val offerOfflineIfMissingSession = true
    open val offerLoginIfInvalidSession = true

    companion object {
        private const val EPG_EXPIRATION_DAYS = 4
    }
}
