package com.twentyfouri.tvlauncher.viewmodels

import android.view.View
import androidx.lifecycle.MutableLiveData
import com.twentyfouri.smartmodel.model.media.SmartAgeRating

class KijkwijzerIconsViewModel : MediaRestrictionIconsViewModel() {

    val contentIcon6 = MutableLiveData<Int>()
    val contentIcon9 = MutableLiveData<Int>()
    val contentIcon12 = MutableLiveData<Int>()
    val contentIcon14 = MutableLiveData<Int>()
    val contentIcon16 = MutableLiveData<Int>()
    val contentIcon18 = MutableLiveData<Int>()
    val contentIconAl = MutableLiveData<Int>()
    val contentIconDiscriminatie = MutableLiveData<Int>()
    val contentIconDrugs = MutableLiveData<Int>()
    val contentIconAngst = MutableLiveData<Int>()
    val contentIconGeweld = MutableLiveData<Int>()
    val contentIconGroftaalgebruik = MutableLiveData<Int>()
    val contentIconSeks = MutableLiveData<Int>()

    init {
        setAllIcons(View.GONE)
    }

    private fun setAllIcons(visibility: Int) {
        contentIcon6.value = visibility
        contentIcon9.value = visibility
        contentIcon12.value = visibility
        contentIcon14.value = visibility
        contentIcon16.value = visibility
        contentIcon18.value = visibility
        contentIconAl.value = visibility
        contentIconDiscriminatie.value = visibility
        contentIconDrugs.value = visibility
        contentIconAngst.value = visibility
        contentIconGeweld.value = visibility
        contentIconGroftaalgebruik.value = visibility
        contentIconSeks.value = visibility
    }

    override fun setContentIcons(ageRating: List<SmartAgeRating>?) {
        setAllIcons(View.GONE)
        if (ageRating == null) return
        for (rating in ageRating) {
            when (rating.rating.toUpperCase()) {
                "5", "6" -> contentIcon6.value = View.VISIBLE
                "7", "8", "9", "10" -> contentIcon9.value = View.VISIBLE
                "11", "12" -> contentIcon12.value = View.VISIBLE
                "13", "14" -> contentIcon14.value = View.VISIBLE
                "15", "16" -> contentIcon16.value = View.VISIBLE
                "17", "18" -> contentIcon18.value = View.VISIBLE
                "AL", "3" -> contentIconAl.value = View.VISIBLE
                "D", "DISCRIMINATIE" -> contentIconDiscriminatie.value = View.VISIBLE
                "H", "DRUGS- EN/OF ALCOHOLMISBRUIK" -> contentIconDrugs.value = View.VISIBLE
                "A", "ANGST" -> contentIconAngst.value = View.VISIBLE
                "G", "GEWELD" -> contentIconGeweld.value = View.VISIBLE
                "T", "GROF TAALGEBRUIK" -> contentIconGroftaalgebruik.value = View.VISIBLE
                "S", "SEKS" -> contentIconSeks.value = View.VISIBLE
            }
        }
    }


}