package com.twentyfouri.tvlauncher.delegates

import android.content.res.AssetManager

class SearchDelegateImpl : SearchableDelegate() {
    /**
     * Searchable apps info getter.
     * @return HashMap<packageName: String, apkFileName: String>
     */
    override fun getSearchableAppsInfo(assetsManager: AssetManager): HashMap<String, String> {
        return buildSearchableAppsInfo(
            assetsManager = assetsManager,
            addSearchableCatchUps = true,
            addSearchableChannels = true,
            addSearchableLiveTvs = true,
            addSearchableRecordings = true
        )
    }
}