package com.twentyfouri.tvlauncher.delegates

import android.content.ComponentName
import android.content.Intent
import android.content.pm.ResolveInfo
import android.util.Log
import com.twentyfouri.androidcore.epg.model.EpgChannel
import com.twentyfouri.androidcore.utils.ImageSpecification
import com.twentyfouri.smartmodel.model.dashboard.SmartMediaItem
import com.twentyfouri.smartmodel.model.dashboard.SmartMediaReference
import com.twentyfouri.smartmodel.model.media.SmartMediaDetail
import com.twentyfouri.tvlauncher.common.data.ResourceRepository
import com.twentyfouri.tvlauncher.data.getPackageName

class AppChannelsDelegateImpl : AppChannelsDelegate() {

    /**
     * @return List of flavor specific app channels package names.
     */
    override fun getAppChannelIDs(): List<String> = listOf()

    /**
     * @param packageName: Name of the app channel app package name.
     * @param prevChID: is a string representing the channel number preceding the app channel.
     * @param nextChID: is a string representing the channel number following the app channel.
     * @return Intent: The intent of the corresponding app from recommended apps row.
     */
    override fun getAppChannelIntent(packageName: String, prevChID: String?, nextChID: String?, isNumberZapp: Boolean): Intent? = null

    /**
     * @param info: Param of class ResolveInfo needed to build the intent.
     * @return Intent: The intent of the corresponding app from apps row.
     */
    override fun getAppIntent(info: ResolveInfo): Intent = buildDefaultIntent(info)

    /**
     * @param info: Param of class ResolveInfo needed to build the intent.
     * @return Intent: The intent of the corresponding app from recommended apps row.
     */
    override fun getRecommendedAppIntent(info: ResolveInfo): Intent = buildDefaultIntent(info)

    override fun getFavoriteAppIntent(info: ResolveInfo): Intent {
        //TODO
        return buildDefaultIntent(info)
    }

    /**
     * @return Intent: The corresponding intent that we will use to launch another app.
     * @param info: Param of class ResolveInfo needed to build the intent.
     */
    private fun buildDefaultIntent(info: ResolveInfo): Intent {
        val intent = Intent.makeMainActivity(
            ComponentName(
                info.getPackageName(),
                info.activityInfo.name
            )
        )
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
        return intent
    }

    /**
     * @param reference: Reference of the app channel app package name.
     * @param prevChID: is a string representing the channel number preceding the app channel.
     * @param nextChID: is a string representing the channel number following the app channel.
     * @return Intent: The intent of the corresponding app from soft zapping.
     */
    override fun getSoftZappingAppChannelIntent(reference: SmartMediaReference, prevChID: String?, nextChID: String?): Intent? = null

    /**
     * @param channel: The app channel (app channels don't have events) from which we want to create a SmartMediaReference.
     * @return SmartMediaReference: SmartMediaReference from the specified channel.
     */
    override fun getAppChannelMediaReference(channel: EpgChannel): SmartMediaReference? = null

    /**
     * @param item: The corresponding app channel smart media item from which we want to get a smart media detail.
     * @param resourceRepository: Resource repository necessary to set values from resources to the params in the smart detail that we will return. For
     * example translated strings or images.
     * @return SmartMediaDetail: Smart media detail with information from the app channel parsed.
     */
    override fun getAppChannelMediaDetail(item: SmartMediaItem, resourceRepository: ResourceRepository): SmartMediaDetail? = null

    /**
     * In some cases we want set a custom image for an app channel.
     * This method is a getter that returns an ImageSpecification of the app channel.
     * @param reference: Reference of the app channel.
     * @param resourceRepository: Resource repository to access the image that we want to return.
     * @return ImageSpecification with the image that we want to set for the app channel.
     */
    override fun getAppChannelSpecificImage(reference: SmartMediaReference, resourceRepository: ResourceRepository): ImageSpecification? = null
}