package com.twentyfouri.tvlauncher.widgets

import android.content.Context
import com.twentyfouri.tvlauncher.viewmodels.PlayerUIViewModel

class PlayerUIViewsAndModels {
    private val uiViews: ArrayList<PlayerUIBase> = arrayListOf()
    var currentUI = PlayerUIEnum.NONE

    fun setCurrentUIView(context: Context, ui: PlayerUIEnum) {
        currentUI = ui
        val existing = getExistingUI(ui)
        if(existing != null) return

        val newOne = when (ui) {
            PlayerUIEnum.NO_CONTROLS -> PlayerUINoControls(context)
            PlayerUIEnum.CATCHUP -> PlayerUICatchup(context)
            PlayerUIEnum.LIVE -> PlayerUILive(context)
            PlayerUIEnum.VOD -> PlayerUIVod(context)
            else -> throw IllegalArgumentException("NONE or not implemented UI requested: $ui")
        }

        uiViews.add(newOne)
    }

    val uiView: PlayerUIBase
        get() { return getExistingUI(currentUI) ?: throw IllegalArgumentException("Player UI View is not available: $currentUI")}

    val uiViewModel: PlayerUIViewModel
            get() { return uiView.viewModel }

    fun getExistingUI(ui: PlayerUIEnum): PlayerUIBase? {
        val c = when(ui) {
            PlayerUIEnum.NO_CONTROLS -> PlayerUINoControls::class.java
            PlayerUIEnum.CATCHUP -> PlayerUICatchup::class.java
            PlayerUIEnum.LIVE -> PlayerUILive::class.java
            PlayerUIEnum.VOD -> PlayerUIVod::class.java
            else -> null
        }
        c ?: return null
        return uiViews.find { it::class.java == c}
    }


}

enum class PlayerUIEnum {
    NONE,
    NO_CONTROLS,
    CATCHUP,
    LIVE,
    VOD
}