package com.twentyfouri.tvlauncher.widgets

import android.content.Context
import android.view.View
import android.widget.FrameLayout
import androidx.databinding.ViewDataBinding
import com.google.android.exoplayer2.Player
import com.twentyfouri.smartexoplayer.tracks.TrackSelector
import com.twentyfouri.smartexoplayer.ui.*
import com.twentyfouri.tvlauncher.R
import com.twentyfouri.tvlauncher.viewmodels.PlayerUIViewModel

abstract class PlayerUIBase(context: Context) : FrameLayout(context), BaseControls, Player.EventListener {

    abstract val binding: ViewDataBinding
    abstract val viewModel: PlayerUIViewModel

    open fun getToastBottomOffset(): Int = resources.getDimensionPixelOffset(R.dimen.toast_above_player_controls_offset)

    fun isUIVisible() = visibility == View.VISIBLE

    fun hideControls() {
        hidingHelper.hidingMode = HidingMode.Hidden
    }

    fun showControls(stayShown: Boolean) {
        hidingHelper.onUserInteraction() //need to call always to reset timeout counter
        if (viewModel.errorState || stayShown) hidingHelper.hidingMode = HidingMode.ShownForced
        else hidingHelper.hidingMode = HidingMode.Shown
    }

    //unused overrides
    override var trackSelector: TrackSelector? = null
    override fun onTapOutside(confirmed: Boolean) {}
    override fun onUserInteraction() {}
    override fun onUserInteractionEnded() {}
    override fun onUserInteractionStarted() {}

    val timerHelper = TimerHelper()
    val hidingHelper = HidingHelper(this)

    protected open val standardHelpers: List<StandardControlsHelper> = emptyList()

    override var player: Player? = null
        set(value) {
            field?.removeListener(this)
            field = value
            standardHelpers.forEach {
                it.player = value
            }
            field?.addListener(this)
        }

    override fun onAttachedToWindow() {
        super.onAttachedToWindow()
        hidingHelper.onUserInteraction()
        standardHelpers.forEach {
            it.interactionNotifier = hidingHelper
            it.onAttachedToWindow()
        }
    }

    override fun onDetachedFromWindow() {
        super.onDetachedFromWindow()
        standardHelpers.forEach {
            it.onDetachedFromWindow()
        }
    }

    override fun onIsPlayingChanged(isPlaying: Boolean) {
        viewModel.applyIsPlaying(isPlaying)
    }

}