package com.twentyfouri.tvlauncher.widgets

import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.LifecycleOwner
import com.twentyfouri.tvlauncher.R
import com.twentyfouri.tvlauncher.data.channel.ExternalRowItem
import com.twentyfouri.tvlauncher.databinding.MetadataAppChannelProgramViewBinding
import com.twentyfouri.tvlauncher.viewmodels.MetadataAppChannelProgramViewModel
import org.koin.core.component.KoinComponent
import org.koin.core.component.get

class MetadataExternalChannelProgramView @JvmOverloads constructor(
    context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0
) : ConstraintLayout(context, attrs, defStyleAttr), KoinComponent {

    var binding: MetadataAppChannelProgramViewBinding = DataBindingUtil.inflate<MetadataAppChannelProgramViewBinding>(
        LayoutInflater.from(context),
        R.layout.metadata_app_channel_program_view,
        this,
        true
    ).apply {
        lifecycleOwner = context as LifecycleOwner
    }

    init {
        binding.viewModel = get<MetadataAppChannelProgramViewModel>()
    }

    fun bind(externalRowItem: ExternalRowItem) {
        binding.viewModel?.setProgram(externalRowItem)
    }
}