package com.twentyfouri.tvlauncher.widgets

import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.LinearLayout
import androidx.databinding.DataBindingUtil
import androidx.databinding.ViewDataBinding
import androidx.lifecycle.LifecycleOwner
import com.twentyfouri.tvlauncher.BR
import com.twentyfouri.tvlauncher.R
import com.twentyfouri.tvlauncher.viewmodels.MediaRestrictionIconsViewModel
import org.koin.core.component.KoinComponent
import org.koin.core.component.get

class MediaRestrictionIcons @JvmOverloads constructor(
    context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0
) : LinearLayout(context, attrs, defStyleAttr), KoinComponent {

    var viewModel : MediaRestrictionIconsViewModel

    init {
        val binding = DataBindingUtil.inflate<ViewDataBinding>(
            LayoutInflater.from(context),
            R.layout.media_restriction_icons,
            this,
            true
        ).apply {
            lifecycleOwner = context as LifecycleOwner
        }
        viewModel = get<MediaRestrictionIconsViewModel>()
        binding.setVariable(BR.viewModel, viewModel)
    }
}