package com.twentyfouri.tvlauncher.widgets

import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.LifecycleOwner
import com.twentyfouri.smartmodel.model.dashboard.SmartMediaItem
import com.twentyfouri.tvlauncher.data.AppListItem
import com.twentyfouri.tvlauncher.R
import com.twentyfouri.tvlauncher.databinding.FloatingLabelBinding
import com.twentyfouri.tvlauncher.extensions.computeLeftEdgeForVerticalAlignementWith
import com.twentyfouri.tvlauncher.viewmodels.FloatingLabelViewModel
import org.koin.core.component.KoinComponent
import org.koin.core.component.get

class FloatingLabelView @JvmOverloads constructor(
    context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0
) : ConstraintLayout(context, attrs, defStyleAttr), KoinComponent {

    var binding: FloatingLabelBinding

    init {
        binding = DataBindingUtil.inflate<FloatingLabelBinding>(
            LayoutInflater.from(context),
            R.layout.floating_label,
            this,
            true
        ).apply {
            lifecycleOwner = context as LifecycleOwner
            viewModel = get<FloatingLabelViewModel>()
        }
    }

    fun bind(mediaItem: SmartMediaItem, view: View) {
        binding.viewModel?.setTextFromMediaItem(mediaItem)
        bind(view)
    }

    fun bind(appListItem: AppListItem, view: View) {
        binding.viewModel?.setTextFromAppListItem(appListItem)
        bind(view)
    }

    private fun bind(view: View) {
        binding.viewModel?.setMarginStart(binding.labelText.computeLeftEdgeForVerticalAlignementWith(view))
    }
}