package com.twentyfouri.tvlauncher.viewmodels

import android.graphics.drawable.Drawable
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.Transformations
import androidx.lifecycle.ViewModel
import com.twentyfouri.smartmodel.model.menu.SmartMenu
import com.twentyfouri.smartmodel.model.menu.SmartMenuType
import com.twentyfouri.tvlauncher.common.data.ResourceRepository
import com.twentyfouri.tvlauncher.Flavor
import com.twentyfouri.tvlauncher.R
import com.twentyfouri.tvlauncher.data.ContentResolverRepository
import com.twentyfouri.tvlauncher.data.MenuRepository
import com.twentyfouri.tvlauncher.utils.StringsMapper
import com.twentyfouri.tvlauncher.utils.ViewHolder

@Suppress("SpellCheckingInspection")
open class TopbarViewModel(
    menuRepository: MenuRepository,
    private val contentResolverRepository: ContentResolverRepository,
    private val resourceRepository: ResourceRepository
) : ViewModel() {
    private val isOffline = MutableLiveData<Boolean>()

    val logoDrawable: LiveData<Drawable>
    val menus: LiveData<List<SmartMenu>>
    val menuLeft: LiveData<ArrayList<ViewHolder<MenuItemViewModel>>>
    val menuRight: LiveData<ArrayList<ViewHolder<MenuItemViewModel>>>

    init {
        logoDrawable = MutableLiveData<Drawable>().apply { value = resourceRepository.getDrawable(R.drawable.app_logo_white_transparent) }
        menus = Transformations.switchMap(isOffline) { isOffline -> menuRepository.getMenusLD(isOffline) }
        menuLeft = Transformations.map(menus) { listOfMenus ->
            listOfMenus
                .firstOrNull { it.type == SmartMenuType.MAIN }
                ?.items
                ?.map {
                    ViewHolder(
                        R.layout.menu_item,
                        MenuItemViewModel(
                            title = StringsMapper.translate(Flavor().getMenuItemTitle(it)),
                            target = it.target,
                            resourceRepository = resourceRepository
                        )
                    )
                }
                .let { if (it == null) ArrayList() else ArrayList(it) }
        }
        menuRight = Transformations.map(menus) { listOfMenus ->
            listOfMenus
                .firstOrNull { it.type == SmartMenuType.TOP }
                ?.items
                ?.map {
                    ViewHolder(
                        R.layout.menu_item_icon,
                        MenuItemViewModel(
                            title = StringsMapper.translate(it.id),
                            target = it.target,
                            resourceRepository = resourceRepository
                        ).apply { setFromMenuItem(it, contentResolverRepository) }
                    )
                }
                ?.let { ArrayList(it) }
                ?: ArrayList()
        }
    }

    fun setIsOffline(boolean: Boolean) { isOffline.value = boolean }

    override fun onCleared() {
        contentResolverRepository.onCleared()
        super.onCleared()
    }
}