package com.twentyfouri.tvlauncher.viewmodels

import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import com.twentyfouri.smartmodel.model.dashboard.SmartMediaItem
import com.twentyfouri.tvlauncher.data.AppListItem

class FloatingLabelViewModel: ViewModel() {
    private val _marginStart = MutableLiveData<Int>()
    private val _text = MutableLiveData<String>()

    val text: LiveData<String> = _text
    val marginStart: LiveData<Int> = _marginStart

    fun setMarginStart(margin: Int) { _marginStart.value = margin }

    fun setTextFromMediaItem(item: SmartMediaItem) { _text.value = item.title ?: "" }

    fun setTextFromAppListItem(item: AppListItem) { _text.value = item.getLabelAsSafeString() }
}