package com.twentyfouri.tvlauncher.viewmodels

import androidx.lifecycle.LiveData
import com.twentyfouri.androidcore.utils.ImageSpecification
import com.twentyfouri.smartmodel.model.dashboard.SmartImages
import com.twentyfouri.smartmodel.model.dashboard.SmartMediaItem
import com.twentyfouri.smartmodel.model.dashboard.SmartPlaylistFilter
import com.twentyfouri.smartmodel.model.dashboard.SmartPlaylistFilterReference
import com.twentyfouri.tvlauncher.Flavor
import com.twentyfouri.tvlauncher.ImageType
import com.twentyfouri.tvlauncher.common.data.ResourceRepository
import com.twentyfouri.tvlauncher.data.EpgRepository
import com.twentyfouri.tvlauncher.data.ListPickerItem
import com.twentyfouri.tvlauncher.utils.ExpirableGlideImageSpecification
import com.twentyfouri.tvlauncher.widgets.SettingsItemType

class FilterChannelViewModel(
    type: Type,
    filters: List<SmartPlaylistFilter>,
    selectedFiltersReferences: Collection<SmartPlaylistFilterReference>,
    resourceRepository: ResourceRepository,
    epgRepository: EpgRepository?
) : FilterViewModel(type, filters, selectedFiltersReferences, resourceRepository) {

    private var channels: LiveData<List<SmartMediaItem>>? = epgRepository?.getAllChannelsLD()

    override fun getPickerItem(filter: SmartPlaylistFilter): ListPickerItem {
        return ListPickerItem(
            id = filter.reference.hashCode().toString(),
            label = "",
            title = filter.reference.title,
            subtitle = "",
            type = SettingsItemType.TITLE_WITH_ICON,
            icon = getIcon(filter)
        )
    }

    private fun getIcon(filter: SmartPlaylistFilter): ImageSpecification? {
        return channels?.value
            ?.find { it.title == filter.reference.title }
            ?.let { Flavor().getImageOfType(it, ImageType.DARK) }
            ?.let { Flavor().pickBasedOnFlavor(it, 1 , 1, SmartImages.UNRESTRICTED) }
            ?.let { ExpirableGlideImageSpecification(it) }
    }
}