package com.twentyfouri.tvlauncher.utils

import android.util.Log
import androidx.fragment.app.commit
import com.google.firebase.crashlytics.FirebaseCrashlytics
import com.twentyfouri.smartmodel.model.dashboard.SmartMediaItem
import com.twentyfouri.tvlauncher.Flavor
import com.twentyfouri.tvlauncher.R
import com.twentyfouri.tvlauncher.ui.BaseFragment
import com.twentyfouri.tvlauncher.ui.PlayerFragment
import timber.log.Timber


class SubscriptionScreenHelper(private val playerFragment: PlayerFragment) {

    private var subscriptionFragment: BaseFragment? = null


    fun showSubscriptionScreen(channelItem: SmartMediaItem){
        if (com.twentyfouri.tvlauncher.common.Flavor().allowSubscriptionPurchaseScreen() && subscriptionFragment == null) {
            subscriptionFragment = Flavor().getSubscriptionFragment(channelItem)
            subscriptionFragment?.let {
                Timber.tag("SubscriptionScreenHelper.showSubscriptionScreen").d("commit $it")
                FirebaseCrashlytics.getInstance().log("SubscriptionScreenHelper.showSubscriptionScreen: commit $it")
                playerFragment.parentFragmentManager.commit {
                    add(R.id.player_frame_overlay, it)
                    addToBackStack(null)
                }
            }
        }
    }

    fun hideSubscriptionScreen() {
        subscriptionFragment?.let {
            Timber.tag("SubscriptionScreenHelper.hideSubscriptionScreen").d("commit $it")
            FirebaseCrashlytics.getInstance().log("SubscriptionScreenHelper.hideSubscriptionScreen: commit $it")
            playerFragment.parentFragmentManager.commit { remove(it) }
            subscriptionFragment = null
        }
    }
}
