package com.twentyfouri.tvlauncher.utils

import android.animation.Animator
import android.animation.AnimatorListenerAdapter
import android.animation.AnimatorSet
import android.animation.ObjectAnimator
import android.os.Handler
import android.view.View
import com.twentyfouri.tvlauncher.R
import com.twentyfouri.tvlauncher.widgets.RowItemView

class ScaleFocusChangeListener(
    private val position: Int
) : View.OnFocusChangeListener {

    override fun onFocusChange(v: View?, focused: Boolean) {
//        Log.d("Rows3", "onFocusChange $position ${v.toString()}")

        val rowItemView: RowItemView = (v as? RowItemView) ?: return
        val card = rowItemView.card
        val title = rowItemView.title
        val smallAnimation = rowItemView.viewModel.useSmallScaleAnimation

        card.pivotX = when {
            smallAnimation && position != 0->  card.width.toFloat() / 2.0f
            else -> 0f
        }
        card.pivotY = card.height.toFloat() / 2.0f

        if (focused) {
            rowItemView.viewModel.setIsFocused(focused)
            card.doTheAnimation(
                titleView = title,
                scale = if (smallAnimation) 1.5f else 1.2f,
                elevation = 8.0f,
                destinationAlpha = 1.0f
            )
            card.cardElevation = rowItemView.context.resources.getDimensionPixelSize(R.dimen.small_card_elevation).toFloat()
        }
        else {
            rowItemView.viewModel.setIsFocused(focused)
            card.doTheAnimation(
                titleView = title,
                scale = 1.0f,
                elevation = 0.0f,
                destinationAlpha = 0.0f
            )
            card.cardElevation = 0f
        }
    }

    private fun View.doTheAnimation(
        titleView: View?,
        scale: Float,
        elevation: Float,
        destinationAlpha: Float,
        onAnimationEnd: () -> Unit = {}
    ) {
        val bannerX = ObjectAnimator.ofFloat(this, View.SCALE_X, scale)
        val bannerY = ObjectAnimator.ofFloat(this, View.SCALE_Y, scale)
        val bannerZ = ObjectAnimator.ofFloat(this, View.TRANSLATION_Z, elevation)

        val animSet = AnimatorSet()
        if (titleView != null) {
            val titleAlpha = ObjectAnimator.ofFloat<View>(
                titleView,
                View.ALPHA,
                destinationAlpha
            )
            animSet.playTogether(bannerX, bannerY, bannerZ, titleAlpha)
        } else {
            animSet.playTogether(bannerX, bannerY, bannerZ)
        }
        animSet.duration = 150L
        animSet.addListener(object : AnimatorListenerAdapter() {
            override fun onAnimationStart(animation: Animator) {
                titleView?.visibility = View.VISIBLE
            }

            override fun onAnimationEnd(animation: Animator) {
                if (titleView?.alpha == 0.0f) {
                    titleView.visibility = View.INVISIBLE //
                } else {
                    titleView?.visibility = View.VISIBLE
                }
                onAnimationEnd.invoke()
            }
        })

        // `Handler().post` is attempt to speed up animation a little -> might be removed in future if nop benefit can be experienced
        Handler().post{ //check if it is not causing a memory leak
            animSet.start()
        }
    }
}