package com.twentyfouri.tvlauncher.utils

fun formatMillisToTime(millis: Long): String {
    val secs = millis / 1000
    return when {
        millis >= 3600000 -> String.format("%d:%02d:%02d", secs / 3600, secs.rem(3600) / 60, secs.rem(60))
        millis >= 60000 -> String.format("%d:%02d", secs / 60, secs.rem(60))
        else -> "$secs"
    }
}