package com.twentyfouri.tvlauncher.utils

import android.util.Log
import com.google.firebase.remoteconfig.FirebaseRemoteConfig
import timber.log.Timber


object FirebaseRemoteConfigHelper {

//    private const val CONFIG_CACHE_EXPIRATION_SECONDS = 14400L
    private val TAG: String = FirebaseRemoteConfigHelper::class.java.simpleName

    fun fetchAndActivate(
        doOnSuccess:() -> Unit,
        doOnFailure: (Exception) -> Unit = {},
        defaultFallback: () -> Unit = {})
    {
        FirebaseRemoteConfig.getInstance().apply {

            // Default fetch interval is 12h. Uncomment this to change it.
//            val configSettings = FirebaseRemoteConfigSettings.Builder()
//                .setMinimumFetchIntervalInSeconds(CONFIG_CACHE_EXPIRATION_SECONDS)
//                .build()
//            setConfigSettingsAsync(configSettings)

            fetchAndActivate()
            .addOnCompleteListener { task ->
                if (task.isSuccessful) {
                    Timber.d("Remote config values fetched and activated")
                    doOnSuccess()
                } else {
                    Timber.d("Remote config values fetch failed -> fallback")
                    defaultFallback()
                }
            }
            .addOnFailureListener {
                doOnFailure(it)
            }
        }

    }

}