package com.twentyfouri.tvlauncher.utils

import androidx.lifecycle.*

class CleanableMediatorLiveData<T>: MediatorLiveData<T>() {

    private val sources: ArrayList<LiveData<*>> = arrayListOf()

    override fun <S : Any?> addSource(source: LiveData<S>, onChanged: Observer<in S>) {
        super.addSource(source, onChanged)
        sources.add(source)
    }

    fun  <S : Any?> replaceAllSource(source: LiveData<S>, onChanged: Observer<in S>) {
        removeAllSources()
        addSource(source, onChanged)
    }

    //set new source of same type and directly assign it on change (map) and also will call back if callback is set
    fun replaceAllSourceAndMap(source: LiveData<T>, callback: (result: T) -> Unit = {}) {
        replaceAllSource(source, Observer {
            callback(it)
            value = it
        })
    }

    fun removeAllSourcesAndSetValue(value: T, reset: Boolean = false) {
        removeAllSources()
        if(reset) {
            this.value = null
            this.postValue(value)
        } else {
            this.value = value
        }
    }

    fun removeAllSources() {
        sources.forEach {
            removeSource(it)
        }
        sources.clear()
    }

    fun reObserve(owner: LifecycleOwner, observer: Observer<in T?>) {
        removeObserver(observer)
        observe(owner, observer)
    }

}