package com.twentyfouri.tvlauncher.ui

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import com.twentyfouri.tvlauncher.R
import com.twentyfouri.tvlauncher.databinding.FragmentMockBinding
import com.twentyfouri.tvlauncher.viewmodels.MockViewModel
import org.koin.androidx.scope.ScopeFragment
import org.koin.androidx.viewmodel.ext.android.getViewModel

class MockFragment : ScopeFragment() {

    private var message : String? = null

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        message = arguments?.get(ARG_MESSAGE) as String

        val mockViewModel = getViewModel<MockViewModel>()
        mockViewModel.message.value = message ?: getString(R.string.text_default)

        val binding = DataBindingUtil.inflate<FragmentMockBinding>(
            inflater,
            R.layout.fragment_mock,
            container,
            false)
            .apply {
                viewModel = mockViewModel
                lifecycleOwner = this@MockFragment.viewLifecycleOwner
            }

        return binding.root
    }

    companion object {
        const val ARG_MESSAGE = "ARG_MESSAGE"

        fun newInstance(message : String): MockFragment {
            val args = Bundle(1)
            args.putString(ARG_MESSAGE, message)
            val fragment = MockFragment()
            fragment.arguments = args
            return fragment
        }
    }
}