package com.twentyfouri.tvlauncher.ui

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import com.twentyfouri.tvlauncher.R
import com.twentyfouri.tvlauncher.adapters.ListPickerAdapter
import com.twentyfouri.tvlauncher.data.ListPickerItem
import com.twentyfouri.tvlauncher.databinding.FragmentFavoriteAppPickerBinding
import com.twentyfouri.tvlauncher.viewmodels.FavoriteAppsPickerViewModel
import org.koin.androidx.viewmodel.ext.android.getViewModel

class FavoriteAppPickerFragment: BaseFragment() {

    private var binding: FragmentFavoriteAppPickerBinding? = null

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View = FragmentFavoriteAppPickerBinding.inflate(
        inflater,
        container,
        false
    ).apply {
        lifecycleOwner = this@FavoriteAppPickerFragment.viewLifecycleOwner
        binding = this
    }.root

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        val viewModelFromFactory = getViewModel<FavoriteAppsPickerViewModel>()

        binding?.viewModel = viewModelFromFactory

        val adapter = ListPickerAdapter { _, item ->
            binding?.viewModel?.onItemClicked(item)
            activity?.finish()
        }

        binding?.appListVerticalRecycler?.adapter = adapter

        binding?.appListVerticalRecycler?.requestFocus()
        adapter.submitList(viewModelFromFactory.getAppListItems())
    }

    override fun onDestroyView() {
        binding = null
        super.onDestroyView()
    }

    override fun onBackPressed(topbarFocused: Boolean): BackPressAction {
        (activity as? FavoriteAppsActivity)?.finish()
        return super.onBackPressed(topbarFocused)
    }
}