package com.twentyfouri.tvlauncher.receiver

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.util.Log
import com.twentyfouri.tvlauncher.common.analytics.YouboraAnalytics
import timber.log.Timber

class PowerOnReceiver: BroadcastReceiver() {
    override fun onReceive(context: Context?, intent: Intent?) {
        Timber.d("intent action ${intent?.action}")
        try {
            context?.also { YouboraAnalytics.getInstance(it).setDeviceIsBooted() }
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }
}