package com.twentyfouri.tvlauncher.provider;


import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.UriMatcher;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.res.XmlResourceParser;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.provider.OpenableColumns;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.MimeTypeMap;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;

import com.twentyfouri.tvlauncher.R;

import org.xmlpull.v1.XmlPullParserException;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import static org.xmlpull.v1.XmlPullParser.END_DOCUMENT;
import static org.xmlpull.v1.XmlPullParser.START_TAG;

import timber.log.Timber;

/**
 * Content provider that provide the Home Screen configuration XML file.
 */
public class ConfigurationProvider extends ContentProvider {
    private static final String TAG = "ConfigurationProvider";
    private static final String CONFIG_AUTHORITY = "tvlauncher.config"; //home screen configuration
    private static final String APPRECS_AUTHORITY = "tvlauncher.apprecs"; //app recommendations
    private static final String WIDGET_AUTHORITY = "tvlauncher.widget"; //widgets
    private static final String CONFIGURATION_DATA = "configuration";
    private static final String APP_RECOMMENDATION_DATA = "app_recommendations";
    private static final String WIDGET_DATA = "widget";
    private static final int MATCH_CONFIGURATION = 1;
    private static final int MATCH_APP_RECOMMENDATIONS = 2;
    private static final int MATCH_WIDGET = 3;
    private static final UriMatcher sUriMatcher;

    static {
        sUriMatcher = new UriMatcher(UriMatcher.NO_MATCH);
        sUriMatcher.addURI(CONFIG_AUTHORITY, CONFIGURATION_DATA, MATCH_CONFIGURATION);
        sUriMatcher.addURI(APPRECS_AUTHORITY, APP_RECOMMENDATION_DATA,
                MATCH_APP_RECOMMENDATIONS);
        sUriMatcher.addURI(WIDGET_AUTHORITY, WIDGET_DATA, MATCH_WIDGET);
    }

    @Nullable
    @Override
    public ParcelFileDescriptor openFile(Uri uri, String mode) throws
            FileNotFoundException {
        final InputStream stream;
        PipeDataWriter writer;
        switch (sUriMatcher.match(uri)) {
            case MATCH_CONFIGURATION:
                // Configuration file is static and resides in
                // the res/raw folder of the app.
                stream = getContext().getResources().openRawResource(
                        R.raw.configuration);
                break;
//            case MATCH_APP_RECOMMENDATIONS:
//                stream = getContext().getResources().openRawResource(
//                        R.raw.recommendations);
//                break;
            default:
                throw new UnsupportedOperationException("Unknown uri: " + uri);
        }
        writer = new PipeDataWriter() {
            @Override
            public void writeDataToPipe(@NonNull ParcelFileDescriptor output,
                                        @NonNull Uri uri, @NonNull String mimeType,
                                        @Nullable Bundle opts, @Nullable Object args) {

                try (FileOutputStream out = new FileOutputStream(output.getFileDescriptor())) {
                    byte[] buffer = new byte[8192];
                    int count;
                    while ((count = stream.read(buffer)) != -1) {
                        out.write(buffer, 0, count);
                    }
                } catch (IOException e) {
                    Timber.e(e, "Failed to send file " + uri);
                }
            }
        };
        return openPipeHelper(uri, "text/xml", null, null, writer);
    }

    @Override
    public boolean onCreate() {
        return true;
    }


    @Nullable
    @Override
    public Cursor query(Uri uri, String[] projection, String selection,
                        String[] selectionArgs, String sortOrder) {
        return null;
//        switch (sUriMatcher.match(uri)) {
//            case MATCH_WIDGET:
//                // In this example , the action uri for the widget points to an activity in
//                // the customization app but the uri can point to separate app too.
//                Intent intent = new Intent(getContext(), WidgetActivity.class);
//                String action = intent.toUri(Intent.URI_INTENT_SCHEME);
//                String title = getContext().getString(R.string.widget_name);
//                // Uri to icon can point to an image on a web server or to an image resource
//                // in the customization app.
//                String icon = "http://url_to_image";
//                MatrixCursor cursor = new MatrixCursor(new String[]{"icon", "title",
//                        "action"});
//                cursor.addRow(new String[] {icon, title, action});
//                return cursor;
//            default:
//                throw new IllegalArgumentException("Unknown URI: " + uri);
//            }
        }
        @Nullable
        @Override
        public Uri insert (Uri uri, ContentValues values){
            throw new UnsupportedOperationException();
        }
        @Override
        public int delete (Uri uri, String selection, String[]selectionArgs){
            throw new UnsupportedOperationException();
        }
        @Override
        public int update (Uri uri, ContentValues values, String selection,
                String[]selectionArgs){
            throw new UnsupportedOperationException();
        }
        @Override
        public String getType (@NonNull Uri uri){
            throw new UnsupportedOperationException();
        }
}