/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
 */

package com.twentyfouri.tvlauncher.notifications

import android.net.Uri

/**
 * Constants which represent the "contract" for interacting with TV notifications.
 */

object NotificationsContract {
    private val PATH_NOTIFS = "notifications"
    private val PATH_NOTIFS_COUNT = "$PATH_NOTIFS/count"

    // Content provider for notifications
    private val AUTHORITY = "com.android.tv.notifications.NotificationContentProvider"

    val CONTENT_URI = Uri.parse(
        "content://" + AUTHORITY + "/" +
                PATH_NOTIFS
    )
    val NOTIFS_COUNT_URI = Uri.parse(
        "content://" + AUTHORITY + "/" +
                PATH_NOTIFS_COUNT
    )

    val ACTION_NOTIFICATION_HIDE = "android.tvservice.action.NOTIFICATION_HIDE"

    val ACTION_SHOW_UNSHOWN_NOTIFICATIONS = "android.tvservice.action.SHOW_UNSHOWN_NOTIFICATIONS"

    val ACTION_OPEN_NOTIFICATION_PANEL = "com.android.tv.NOTIFICATIONS_PANEL"

    val NOTIFICATION_KEY = "sbn_key"

    val COLUMN_SBN_KEY = "sbn_key"
    val COLUMN_PACKAGE_NAME = "package_name"
    val COLUMN_NOTIF_TITLE = "title"
    val COLUMN_NOTIF_TEXT = "text"
    val COLUMN_AUTODISMISS = "is_auto_dismiss"
    val COLUMN_DISMISSIBLE = "dismissible"
    val COLUMN_ONGOING = "ongoing"
    val COLUMN_SMALL_ICON = "small_icon"
    val COLUMN_CHANNEL = "channel"
    val COLUMN_PROGRESS = "progress"
    val COLUMN_PROGRESS_MAX = "progress_max"
    val COLUMN_NOTIFICATION_HIDDEN = "notification_hidden"
    val COLUMN_FLAGS = "flags"
    val COLUMN_HAS_CONTENT_INTENT = "has_content_intent"
    val COLUMN_BIG_PICTURE = "big_picture"
    val COLUMN_CONTENT_BUTTON_LABEL = "content_button_label"
    val COLUMN_DISMISS_BUTTON_LABEL = "dismiss_button_label"
    val COLUMN_TAG = "tag"

    val COLUMN_COUNT = "count"
}
