package com.twentyfouri.tvlauncher.homepagechannels.room

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.Query

@Dao
interface HomepageChannelDAO {

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insertChannels(vararg homepageChannels: HomepageChannel)

    @Query("SELECT * FROM homepage_channel")
    suspend fun getAllChannels() : List<HomepageChannel>

    @Query("SELECT * FROM homepage_channel WHERE channel_id = :channelId")
    suspend fun find(channelId: Long): HomepageChannel

    @Query("SELECT * FROM homepage_channel WHERE name = :name")
    suspend fun find(name: String): HomepageChannel

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insertChannelItems(vararg channelItems: HomepageChannelItem)

    @Query("DELETE FROM homepage_channel_item WHERE channel_id = :channelId")
    suspend fun deleteChannelItems(channelId: Long)

    @Query("SELECT * FROM homepage_channel_item WHERE channel_id = :channelId")
    suspend fun getChannelItems(channelId: Long) : List<HomepageChannelItem>

    @Query("SELECT * FROM homepage_channel_item WHERE channel_id = :channelId AND id = :itemId")
    suspend fun getChannelItem(channelId: Long, itemId: Long) : HomepageChannelItem
}