package com.twentyfouri.tvlauncher.homepagechannels

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.util.Log
import timber.log.Timber

/** Initializes channels and programs at installation time.  */
class InitializeChannelsReceiver : BroadcastReceiver() {

    override fun onReceive(context: Context, intent: Intent) {
        Timber.d("onReceive(): $intent")
        TvUtil.scheduleSyncingChannel(context)
    }

    companion object {
        private const val TAG = "InitializeChannelsRcvr"
    }
}