package com.twentyfouri.tvlauncher.extensions

import android.os.Bundle
import androidx.fragment.app.Fragment
import java.io.Serializable

fun Fragment.putString(key : String, value: String) {
    val args = arguments ?: Bundle(1)
    args.putString(key, value)
    arguments = args
}

fun Fragment.putInt(key : String, value: Int) {
    val args = arguments ?: Bundle(1)
    args.putInt(key, value)
    arguments = args
}

fun Fragment.putBoolean(key : String, value: Boolean) {
    val args = arguments ?: Bundle(1)
    args.putBoolean(key, value)
    arguments = args
}

fun Fragment.putSerializable(key : String, value: Serializable?) {
    val args = arguments ?: Bundle(1)
    args.putSerializable(key, value)
    arguments = args
}