package com.twentyfouri.tvlauncher.di

import android.view.ViewGroup
import androidx.fragment.app.findFragment
import androidx.lifecycle.ViewModel
import com.twentyfouri.tvlauncher.ui.BaseActivity
import com.twentyfouri.tvlauncher.ui.MainActivity
import com.twentyfouri.tvlauncher.ui.RowPageFragment
import com.twentyfouri.tvlauncher.widgets.PlayerUIBase
import com.twentyfouri.tvlauncher.widgets.RowItemView
import org.koin.androidx.viewmodel.ext.android.getViewModel
import kotlin.properties.ReadOnlyProperty
import kotlin.reflect.KProperty

/**
 * USAGE:
 * class CustomView @JvmOverloads constructor(
 * context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0, defStyleRes: Int = 0
 * ) : FrameLayout(context, attrs, defStyleAttr, defStyleRes) {
 * private val viewModel: CustomViewModel by viewModel()
 * }
 * */
internal inline fun <reified T : ViewModel> ViewGroup.viewModel(): ReadOnlyProperty<ViewGroup, T> =
    object : ReadOnlyProperty<ViewGroup, T> {

        private var viewModel: T? = null

        override operator fun getValue(
            thisRef: ViewGroup,
            property: KProperty<*>
        ): T = viewModel ?: createViewModel(thisRef).also { viewModel = it }

        private fun createViewModel(thisRef: ViewGroup): T {
            return when (thisRef) {
                is PlayerUIBase -> (thisRef.context as MainActivity).getPlayerFragment()!!.getViewModel<T>()
                is RowItemView -> thisRef.findFragment<RowPageFragment>().getViewModel()
                else -> (thisRef.context as BaseActivity).getViewModel()
            }
        }
    }