@file:Suppress("unused")

package com.twentyfouri.tvlauncher.data.channel

import android.database.Cursor
import androidx.tvprovider.media.tv.TvContractCompat
import java.lang.IllegalArgumentException

data class ExternalRowItem(
    var actionUri: String = "",
    var author: String = "",
    var availability: Int = 0,
    var canonicalGenres: String = "",
    var channelId: Long = 0,
    var contentId: String = "",
    var contentRating: String = "",
    var duration: Long = 0,
    var episodeDisplayNumber: String = "",
    var episodeTitle: String = "",
    var genre: String = "",
    var id: Long = 0,
    var interactionCount: Long = 0,
    var interactionType: Int = 0,
    var itemCount: Int = 0,
    var lastEngagementTime: Long = 0,
    var liveEndTime: Long = 0,
    var liveStartTime: Long = 0,
    var logoContentDescription: String = "",
    var logoUri: String = "",
    var offerPrice: String = "",
    var packageName: String = "",
    var playbackPosition: Long = 0,
    var previewAudioUri: String = "",
    var previewImageAspectRatio: Int = 0,
    var previewImageUri: String = "",
    var previewVideoUri: String = "",
    var releaseDate: String = "",
    var reviewRating: String = "",
    var reviewRatingStyle: Int = 0,
    var seasonDisplayNumber: String = "",
    var shortDescription: String = "",
    var startingPrice: String = "",
    var thumbnailAspectRatio: Int = 0,
    var thumbnailUri: String = "",
    var title: String = "",
    var type: Int = 0,
    var videoHeight: Int = 0,
    var videoWidth: Int = 0,
    var watchNextType: Int = 0,
    var isLive: Boolean = false
) {

    override fun toString(): String {
        return "Program{id=$id, channelId=$channelId, title='$title', previewImageUri='$previewImageUri', previewVideoUri='$previewVideoUri'}"
    }

    override fun equals(other: Any?): Boolean =
        other is ExternalRowItem
                && actionUri == other.actionUri
                && author == other.author
                && availability == other.availability
                && canonicalGenres == other.canonicalGenres
                && channelId == other.channelId
                && contentId == other.contentId
                && contentRating == other.contentRating
                && duration == other.duration
                && episodeDisplayNumber == other.episodeDisplayNumber
                && episodeTitle == other.episodeTitle
                && genre == other.genre
                && id == other.id
                && interactionCount == other.interactionCount
                && interactionType == other.interactionType
                && itemCount == other.itemCount
                && lastEngagementTime == other.lastEngagementTime
                && liveEndTime == other.liveEndTime
                && liveStartTime == other.liveStartTime
                && logoContentDescription == other.logoContentDescription
                && logoUri == other.logoUri
                && offerPrice == other.offerPrice
                && packageName == other.packageName
                && playbackPosition == other.playbackPosition
                && previewAudioUri == other.previewAudioUri
                && previewImageAspectRatio == other.previewImageAspectRatio
                && previewImageUri == other.previewImageUri
                && previewVideoUri == other.previewVideoUri
                && releaseDate == other.releaseDate
                && reviewRating == other.reviewRating
                && reviewRatingStyle == other.reviewRatingStyle
                && seasonDisplayNumber == other.seasonDisplayNumber
                && shortDescription == other.shortDescription
                && startingPrice == other.startingPrice
                && thumbnailAspectRatio == other.thumbnailAspectRatio
                && thumbnailUri == other.thumbnailUri
                && title == other.title
                && type == other.type
                && videoHeight == other.videoHeight
                && videoWidth == other.videoWidth
                && watchNextType == other.watchNextType
                && isLive == other.isLive

    override fun hashCode(): Int {
        var result = actionUri.hashCode()
        result = 31 * result + channelId.hashCode()
        result = 31 * result + contentId.hashCode()
        result = 31 * result + id.hashCode()
        result = 31 * result + packageName.hashCode()
        result = 31 * result + playbackPosition.hashCode()
        result = 31 * result + title.hashCode()
        result = 31 * result + type
        return result
    }

    companion object {
        fun fromCursor(cursor: Cursor, watchNext: Boolean = false): ExternalRowItem {
            return try {
                ExternalRowItem().apply {
                    id = cursor.getSafeLong(0)
                    channelId = cursor.getSafeLong(1)
                    type = cursor.getSafeInt(2)
                    title = cursor.getSafeString(3)
                    shortDescription = cursor.getSafeString(4)
                    previewImageUri = cursor.getSafeString(5)
                    previewImageAspectRatio = cursor.getSafeInt(6)
                    thumbnailUri = cursor.getSafeString(7)
                    thumbnailAspectRatio = cursor.getSafeInt(8)
                    previewVideoUri = cursor.getSafeString(9)
                    previewAudioUri = cursor.getSafeString(10)
                    actionUri = cursor.getSafeString(11)
                    author = cursor.getSafeString(12)
                    releaseDate = cursor.getSafeString(13)
                    interactionType = cursor.getSafeInt(14)
                    interactionCount = cursor.getSafeLong(15)
                    availability = cursor.getSafeInt(16)
                    startingPrice = cursor.getSafeString(17)
                    offerPrice = cursor.getSafeString(18)
                    contentRating = cursor.getSafeString(19)
                    logoUri = cursor.getSafeString(20)
                    logoContentDescription = cursor.getSafeString(21)
                    canonicalGenres = cursor.getSafeString(22)
                    duration = cursor.getSafeLong(23)
                    itemCount = cursor.getSafeInt(24)
                    seasonDisplayNumber = cursor.getSafeString(25)
                    episodeDisplayNumber = cursor.getSafeString(26)
                    episodeTitle = cursor.getSafeString(27)
                    playbackPosition = cursor.getSafeLong(28)
                    contentId = cursor.getSafeString(29)
                    reviewRatingStyle = cursor.getSafeInt(30)
                    reviewRating = cursor.getSafeString(31)
                    isLive = cursor.getSafeInt(32) == 1
                    liveStartTime = cursor.getSafeLong(33)
                    liveEndTime = cursor.getSafeLong(34)
                    videoWidth = cursor.getSafeInt(35)
                    videoHeight = cursor.getSafeInt(36)
                    genre = cursor.getSafeString(37)
                    packageName = cursor.getSafeString(38)

                    if (watchNext) {
                        watchNextType = cursor.getSafeInt(39)
                        lastEngagementTime = cursor.getSafeLong(40)
//                        packageName = cursor.getSafeString(40)
                    }
                }
            } catch (t: Throwable) {
                throw IllegalArgumentException("Cursor for program was broken in some way").apply { addSuppressed(t) }
            }
        }

        private fun Cursor.getSafeString(position: Int): String {
            return try {
                getString(position)
            } catch (t: Throwable) {
                ""
            }
        }

        private fun Cursor.getSafeLong(position: Int): Long {
            return try {
                getLong(position)
            } catch (t: Throwable) {
                0
            }
        }

        private fun Cursor.getSafeInt(position: Int): Int {
            return try {
                getInt(position)
            } catch (t: Throwable) {
                0
            }
        }

        val PROJECTION = arrayOf(
            "_id",
            "channel_id",
            "type",
            "title",
            TvContractCompat.Programs.COLUMN_SHORT_DESCRIPTION,
            TvContractCompat.Programs.COLUMN_POSTER_ART_URI,
            TvContractCompat.PreviewProgramColumns.COLUMN_POSTER_ART_ASPECT_RATIO,
            TvContractCompat.Programs.COLUMN_THUMBNAIL_URI,
            TvContractCompat.PreviewProgramColumns.COLUMN_THUMBNAIL_ASPECT_RATIO,
            TvContractCompat.PreviewProgramColumns.COLUMN_PREVIEW_VIDEO_URI,
            "preview_audio_uri",
            TvContractCompat.PreviewProgramColumns.COLUMN_INTENT_URI,
            TvContractCompat.PreviewProgramColumns.COLUMN_AUTHOR,
            TvContractCompat.PreviewProgramColumns.COLUMN_RELEASE_DATE,
            TvContractCompat.PreviewProgramColumns.COLUMN_INTERACTION_TYPE,
            TvContractCompat.PreviewProgramColumns.COLUMN_INTERACTION_COUNT,
            TvContractCompat.PreviewProgramColumns.COLUMN_AVAILABILITY,
            TvContractCompat.PreviewProgramColumns.COLUMN_STARTING_PRICE,
            TvContractCompat.PreviewProgramColumns.COLUMN_OFFER_PRICE,
            TvContractCompat.Programs.COLUMN_CONTENT_RATING,
            TvContractCompat.PreviewProgramColumns.COLUMN_LOGO_URI,
            "logo_content_description",
            "canonical_genre",
            "genre",
            TvContractCompat.PreviewProgramColumns.COLUMN_DURATION_MILLIS,
            TvContractCompat.PreviewProgramColumns.COLUMN_ITEM_COUNT,
            TvContractCompat.Programs.COLUMN_SEASON_DISPLAY_NUMBER,
            TvContractCompat.Programs.COLUMN_EPISODE_DISPLAY_NUMBER,
            TvContractCompat.Programs.COLUMN_EPISODE_TITLE,
            TvContractCompat.PreviewProgramColumns.COLUMN_LAST_PLAYBACK_POSITION_MILLIS,
            TvContractCompat.PreviewProgramColumns.COLUMN_CONTENT_ID,
            TvContractCompat.Programs.COLUMN_REVIEW_RATING_STYLE,
            TvContractCompat.Programs.COLUMN_REVIEW_RATING,
            TvContractCompat.PreviewProgramColumns.COLUMN_LIVE,
            "start_time_utc_millis",
            "end_time_utc_millis",
            TvContractCompat.Programs.COLUMN_VIDEO_WIDTH,
            TvContractCompat.Programs.COLUMN_VIDEO_HEIGHT,
            "package_name"
        )
        val WATCH_NEXT_PROJECTION = PROJECTION + arrayOf(
            TvContractCompat.WatchNextPrograms.COLUMN_WATCH_NEXT_TYPE,
            TvContractCompat.WatchNextPrograms.COLUMN_LAST_ENGAGEMENT_TIME_UTC_MILLIS
//            "package_name"
        )
    }
}
