package com.twentyfouri.tvlauncher.data

import android.content.Context
import android.content.res.TypedArray
import com.twentyfouri.tvlauncher.R

object SpecialAppLists {

    @JvmStatic
    fun getRecommendedAppList(context: Context): List<String> {
        return context.resources.getStringArray(R.array.recommended_apps_list).toList()
    }

    @JvmStatic
    fun getHighPriorityApps(context: Context): List<String> {
        return context.resources.getStringArray(R.array.high_priority_apps).toList()
    }

    @JvmStatic
    fun getFixedPriorityApps(context: Context): List<String> {
        return context.resources.getStringArray(R.array.fixed_priority_apps).toList()
    }

    @JvmStatic
    fun getHiddenAppsList(context: Context): List<String> {
        // Apps to be hidden in the app list
        return context.resources.getStringArray(R.array.hidden_apps_list).toList()
    }

    @JvmStatic
    fun getAllowedAppRows(context: Context): TypedArray {
        return context.resources.obtainTypedArray(R.array.allowed_app_rows)
    }
}