package com.twentyfouri.tvlauncher.data

import android.content.Intent
import android.service.notification.NotificationListenerService
import android.service.notification.StatusBarNotification
import com.twentyfouri.tvlauncher.data.ContentResolverRepository.Companion.NOTIFICATION_UPDATE_INTENT_ACTION

class NotificationListenerServiceTVLauncher : NotificationListenerService() {

    override fun onNotificationPosted(sbn: StatusBarNotification?) {
        sbn?.let { informLauncher("POSTED ${sbn.notification}") }
    }

    override fun onNotificationRemoved(sbn: StatusBarNotification?) {
        sbn?.let { informLauncher("REMOVED ${it.notification}") }
    }

    private fun informLauncher(message: String) {
        val i = Intent(NOTIFICATION_UPDATE_INTENT_ACTION)
        i.`package` = packageName
        i.putExtra("notification_event", message)
        sendBroadcast(i)
    }
}