package com.twentyfouri.tvlauncher.data

import com.twentyfouri.smartmodel.model.dashboard.SmartPage
import com.twentyfouri.smartmodel.model.dashboard.SmartPageSection
import com.twentyfouri.tvlauncher.Flavor

object HardcodedPageMapper {

    fun convertPage(page: SmartPage, apiInitFailed: Boolean = false, hasConnectivity: Boolean, serverBusy: Boolean): SmartPage {
        //for some reason, when the app is going offline the APPS page can be the server instance of it !!!, and empty !!!. So here we do "if it is offline,
        //I don't care who you say you are, you are APPS page now"
        val isAppsPage = Flavor().isAppsPage(page.reference)
        if (isAppsPage || apiInitFailed) {
            page.sections = buildList {
                if (isAppsPage && (hasConnectivity || serverBusy)) add(convertOffline())
                add(convertPlayStore())
                add(convertRecommendedApps())
                add(convertAllApps())
                add(convertAllGames())
            }
        }
        //uncomment if you want to display just one particular row
//        ((page.reference as? PhoenixPageReference)?.id == STG_HOME_PAGE_ID).ifTrue { page.sections = arrayListOf(page.sections.last()) }
        return page
    }

    private fun convertOffline(): SmartPageSection {
        val smartPageSection = SmartPageSection(
            id = "offline",
            label = "",
            playlistReference = HardcodedPlaylistReference(HardcodedPlaylistReference.Type.OFFLINE)
        )
        smartPageSection.sectionStyle = HardcodedPlaylistReference.Type.OFFLINE.toString()
        return smartPageSection
    }

    @Suppress("MemberVisibilityCanBePrivate")
    fun convertRecommendedApps(): SmartPageSection {
        val smartPageSection = SmartPageSection(
            id = "recommended",
            label = "Recommended",
            playlistReference = HardcodedPlaylistReference(HardcodedPlaylistReference.Type.RECOMMENDED_APPS)
        )
        smartPageSection.sectionStyle = HardcodedPlaylistReference.Type.RECOMMENDED_APPS.toString()
        return smartPageSection
    }

    private fun convertAllApps(): SmartPageSection {
        val smartPageSection = SmartPageSection(
            id = "all_apps",
            label = "All Apps",
            playlistReference = HardcodedPlaylistReference(HardcodedPlaylistReference.Type.ALL_APPS)
        )
        smartPageSection.sectionStyle = HardcodedPlaylistReference.Type.ALL_APPS.toString()
        return smartPageSection
    }

    private fun convertAllGames(): SmartPageSection {
        val smartPageSection = SmartPageSection(
            id = "all_games",
            label = "Games",
            playlistReference = HardcodedPlaylistReference(HardcodedPlaylistReference.Type.ALL_GAMES)
        )
        smartPageSection.sectionStyle = HardcodedPlaylistReference.Type.ALL_GAMES.toString()
        return smartPageSection
    }

    private fun convertPlayStore(): SmartPageSection {
        val smartPageSection = SmartPageSection(
            id = "play_store",
            label = "Play Store",
            playlistReference = HardcodedPlaylistReference(HardcodedPlaylistReference.Type.PLAY_STORE)
        )
        smartPageSection.sectionStyle = HardcodedPlaylistReference.Type.PLAY_STORE.toString()
        return smartPageSection
    }

    fun convertFavoriteApps(): SmartPageSection {
        val smartPageSection = SmartPageSection(
            id = "favorite_apps",
            label = "Recommended",
            playlistReference = HardcodedPlaylistReference(HardcodedPlaylistReference.Type.FAVORITE_APPS),
            refreshOnResume = true
        )
        smartPageSection.sectionStyle = HardcodedPlaylistReference.Type.FAVORITE_APPS.toString()
        return smartPageSection
    }

    private const val REFRESH_TIME = 60*1000
}