package com.twentyfouri.tvlauncher.data

import android.util.Log
import com.twentyfouri.smartmodel.model.menu.*
import com.twentyfouri.tvlauncher.BuildConfig
import com.twentyfouri.tvlauncher.Flavor
import com.twentyfouri.tvlauncher.common.extensions.ifFalse
import timber.log.Timber
import java.util.*

object HardcodedMenuMapper {

    fun getOfflineMenus(): ArrayList<SmartMenu> {
        return ArrayList<SmartMenu>().apply {
            add(
                SmartMenu(SmartMenuType.MAIN).apply {
                    items.add(convertApps())
                }
            )
            add(
                SmartMenu(SmartMenuType.TOP).apply {
                    ifLauncherDo { items.add(convertNotifications()) }
                    if(Flavor().displayDiagnosticsMenuIcon) items.add(convertDiagnostics())
                    if(com.twentyfouri.tvlauncher.common.Flavor().parentalRulesRefreshActivated) items.add(convertPersonal())
                    items.add(convertVoice())
                    items.add(convertSearch())
                    items.add(convertSettings())
                }
            )
        }
    }

    private inline fun ifLauncherDo(block: () -> Unit) {
        if (BuildConfig.IS_APP.not())
            block()
    }

    fun addServerMenusToOfflineMenus(serverMenus: List<SmartMenu>?, offlineMenus: ArrayList<SmartMenu>) {
        serverMenus ?: return
        convertMainMenu(
            serverMenus.find { it.type == SmartMenuType.MAIN },
            offlineMenus.find { it.type == SmartMenuType.MAIN }
        )
        convertTopMenu(
            serverMenus.find { it.type == SmartMenuType.TOP },
            offlineMenus.find { it.type == SmartMenuType.TOP }
        )
    }

    private fun convertMainMenu(serverMainMenu: SmartMenu?, offlineMainMenu: SmartMenu?) {
        ArrayList<SmartMenuItem>().apply {
            var appsPageWasAddedFromServer = false
            serverMainMenu?.items?.forEach {
                if (Flavor().isAppsPage(it.target?.pageReference)) {
                    it.target = SmartNavigationTarget.toBrowsePage(HardcodedPageReference(
                        HardcodedPageReference.Type.APPS))
                    appsPageWasAddedFromServer = true
                }
            }
            addAll(serverMainMenu?.items ?: emptyList())
            Timber.tag("menus").d("appsPageWasAddedFromServer $appsPageWasAddedFromServer")
            appsPageWasAddedFromServer.ifFalse { addAll(offlineMainMenu?.items ?: emptyList()) }
            Timber.tag("menus").d("convertMainMenu ${this.size}")
            offlineMainMenu?.items = this
        }
    }

    private fun convertTopMenu(serverTopMenu: SmartMenu?, offlineTopMenu: SmartMenu?) {
        ArrayList<SmartMenuItem>().apply{
            addAll(offlineTopMenu?.items?.let { it.take(it.size-1) } ?: emptyList())
            addAll(serverTopMenu?.items ?: emptyList())
            offlineTopMenu?.items?.last()?.let { add(it) }
            offlineTopMenu?.items = this
        }
    }

    private fun convertApps() : SmartMenuItem {
        return SmartMenuItem(
            id = Type.APPS.toString(),
            label = Type.APPS.toString(),
            target = SmartNavigationTarget.toBrowsePage(
                HardcodedPageReference(HardcodedPageReference.Type.APPS)
            )
        )
    }

    private fun convertNotifications() : SmartMenuItem {
        return SmartMenuItem(
            id = Type.NOTIFICATIONS.toString(),
            target = SmartNavigationTarget.to(SmartNavigationAction.NOTIFICATIONS)
        )
    }

    private fun convertVoice() : SmartMenuItem {
        return SmartMenuItem(
            id = Type.VOICE.toString(),
            target = SmartNavigationTarget.to(SmartNavigationAction.VOICE_SEARCH)
        )
    }

     private fun convertDiagnostics(): SmartMenuItem {
         return  SmartMenuItem(
             id = Type.DIAGNOSTICS.toString(),
             target = SmartNavigationTarget.to(SmartNavigationAction.DIAGNOSTICS)
         )
     }

    private fun convertSearch() : SmartMenuItem {
        return SmartMenuItem(
            id = Type.SEARCH.toString(),
            target = SmartNavigationTarget.toSearch("")
        )
    }

    private fun convertSettings() : SmartMenuItem {
        return SmartMenuItem(
            id = Type.SETTINGS.toString(),
            target = SmartNavigationTarget.to(SmartNavigationAction.SETTINGS)
        )
    }

    private fun convertPersonal() : SmartMenuItem {
        return SmartMenuItem(
                id = Type.PERSONAL.toString(),
                target = SmartNavigationTarget.to(SmartNavigationAction.USER_PROFILE)
        )
    }

    enum class Type{
        APPS,
        NOTIFICATIONS,
        VOICE,
        SEARCH,
        SETTINGS,
        DIAGNOSTICS,
        PERSONAL,
        EPG,
        HOME
    }
}