package com.twentyfouri.tvlauncher.data

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.Query

@Dao
interface AppUsageDao {
    @Query("SELECT timeOfUse FROM appusage WHERE packageName IN (:packageName)")
    fun getTimeOfUseByPackageName(packageName: String): Long

    @Query("UPDATE appusage SET timeOfUse = :timeOfUse WHERE packageName = :packageName")
    fun updateTimeOfUseByPackageName(timeOfUse: Long, packageName: String)

    @Insert
    fun insert(appUsage: AppUsage)

    @Query("SELECT * From appusage WHERE favoritePriority > 0 ORDER BY favoritePriority ASC")
    fun getAllFavoriteApps(): List<AppUsage>

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    fun insertFavoriteApps(appUsageList: List<AppUsage>)

    @Query("DELETE FROM appusage WHERE packageName IN (:appsToDelete)")
    fun deleteFavoriteApps(appsToDelete: List<String>)

}