package com.twentyfouri.tvlauncher.adapters

import android.view.View
import android.widget.TextView
import com.twentyfouri.tvlauncher.R
import com.twentyfouri.tvlauncher.ui.MainActivity
import com.twentyfouri.tvlauncher.viewmodels.RowViewModel

class MockRowViewHolder(
        override val rowView: View
): RowAdapterViewHolder(rowView) {
    override fun bind(rowViewModel: RowViewModel, position: Int) {
        rowView.findViewById<TextView>(R.id.row_mock_label)?.apply {
            text = "$position ${rowViewModel.sectionViewModel.pageSection.label}"
        }
    }

    override fun onAttached() {
        val mainActivity = rowView.context as? MainActivity ?: return
        mainActivity.navigateLoader(
                visible = false,
                handleSplash = true,
                delay = rowView.context.resources.getInteger(R.integer.splash_screen_loading_offset).toLong()
        )
    }
}